// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_trustedhtml_trustedscript_trustedscripturl.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_html.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_trusted_script_url.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_html.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script.h"
#include "third_party/blink/renderer/core/trustedtypes/trusted_script_url.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL* V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8TrustedScriptURL::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8TrustedScriptURL::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL>(blink_value);
}
if (V8TrustedScript::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8TrustedScript::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL>(blink_value);
}
if (V8TrustedHTML::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8TrustedHTML::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













void V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL::Trace(Visitor* visitor) const {
  visitor->Trace(member_trusted_html_);
visitor->Trace(member_trusted_script_);
visitor->Trace(member_trusted_script_url_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionTrustedHTMLOrTrustedScriptOrTrustedScriptURL::Clear() {
  member_trusted_html_.Clear();
member_trusted_script_.Clear();
member_trusted_script_url_.Clear();
}



}  // namespace blink
