// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_string_stringsequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionStringOrStringSequence* V8UnionStringOrStringSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<IDLString>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrStringSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLString>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrStringSequence>(std::move(blink_value));
}
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionStringOrStringSequence>(std::move(blink_value));
}
}

 V8UnionStringOrStringSequence::V8UnionStringOrStringSequence(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionStringOrStringSequence::V8UnionStringOrStringSequence(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}

 V8UnionStringOrStringSequence::V8UnionStringOrStringSequence(const Vector<String>& value) : content_type_(ContentType::kStringSequence), member_string_sequence_(value) {
  
}

 V8UnionStringOrStringSequence::V8UnionStringOrStringSequence(Vector<String>&& value) : content_type_(ContentType::kStringSequence), member_string_sequence_(std::move(value)) {
  
}




void V8UnionStringOrStringSequence::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionStringOrStringSequence::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}



void V8UnionStringOrStringSequence::Set(const Vector<String>& value) {
  Clear();
member_string_sequence_ = value;
content_type_ = ContentType::kStringSequence;
}

void V8UnionStringOrStringSequence::Set(Vector<String>&& value) {
  Clear();
member_string_sequence_ = std::move(value);
content_type_ = ContentType::kStringSequence;
}


v8::Local<v8::Value> V8UnionStringOrStringSequence::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
  case ContentType::kStringSequence: {
    return ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_string_sequence_);
  }
}

NOTREACHED();
}

void V8UnionStringOrStringSequence::Trace(Visitor* visitor) const {
  bindings::UnionBase::Trace(visitor);
}

void V8UnionStringOrStringSequence::Clear() {
  member_string_ = String();
member_string_sequence_.clear();
}



}  // namespace blink
