// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_response_undefined.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_response.h"
#include "third_party/blink/renderer/core/fetch/response.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionResponseOrUndefined* V8UnionResponseOrUndefined::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsUndefined()) {
  ToV8UndefinedGenerator blink_value;
return MakeGarbageCollected<V8UnionResponseOrUndefined>(blink_value);
}
if (V8Response::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Response::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionResponseOrUndefined>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionResponseOrUndefined::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kResponse: {
    return ToV8Traits<Response>::ToV8(script_state, member_response_.Get());
  }
  case ContentType::kUndefined: {
    return ToV8Traits<IDLUndefined>::ToV8(script_state, member_undefined_);
  }
}

NOTREACHED();
}

void V8UnionResponseOrUndefined::Trace(Visitor* visitor) const {
  visitor->Trace(member_response_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionResponseOrUndefined::Clear() {
  member_response_.Clear();
}



}  // namespace blink
