// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_request_requestorusvstringsequence_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_request_usvstring.h"
#include "third_party/blink/renderer/core/fetch/request.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString* V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8Request::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Request::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString>(blink_value);
}
if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<V8UnionRequestOrUSVString>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<V8UnionRequestOrUSVString>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString>(std::move(blink_value));
}
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString>(std::move(blink_value));
}
}

 V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString(const HeapVector<Member<V8UnionRequestOrUSVString>>& value) : content_type_(ContentType::kRequestOrUSVStringSequence), member_request_or_usv_string_sequence_(value) {
  
}

 V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString(HeapVector<Member<V8UnionRequestOrUSVString>>&& value) : content_type_(ContentType::kRequestOrUSVStringSequence), member_request_or_usv_string_sequence_(std::move(value)) {
  
}

 V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}







void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Set(const HeapVector<Member<V8UnionRequestOrUSVString>>& value) {
  Clear();
member_request_or_usv_string_sequence_ = value;
content_type_ = ContentType::kRequestOrUSVStringSequence;
}

void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Set(HeapVector<Member<V8UnionRequestOrUSVString>>&& value) {
  Clear();
member_request_or_usv_string_sequence_ = std::move(value);
content_type_ = ContentType::kRequestOrUSVStringSequence;
}



void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


V8UnionRequestOrUSVString* V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::GetAsV8UnionRequestOrUSVString() const {
  switch (content_type_) {
  case ContentType::kRequest: {
    return MakeGarbageCollected<V8UnionRequestOrUSVString>(GetAsRequest());
  }
  case ContentType::kUSVString: {
    return MakeGarbageCollected<V8UnionRequestOrUSVString>(GetAsUSVString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Set(const V8UnionRequestOrUSVString* value) {
  switch (value->GetContentType()) {
  case V8UnionRequestOrUSVString::ContentType::kRequest: {
    Set(value->GetAsRequest());
    break;
  }
  case V8UnionRequestOrUSVString::ContentType::kUSVString: {
    Set(value->GetAsUSVString());
    break;
  }
}
}




void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_request_);
visitor->Trace(member_request_or_usv_string_sequence_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionRequestOrRequestOrUSVStringSequenceOrUSVString::Clear() {
  member_request_.Clear();
member_request_or_usv_string_sequence_.clear();
member_usv_string_ = String();
}



}  // namespace blink
