// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLEBYTESTREAMCONTROLLER_READABLESTREAMDEFAULTCONTROLLER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLEBYTESTREAMCONTROLLER_READABLESTREAMDEFAULTCONTROLLER_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ReadableByteStreamController;
class ReadableStreamDefaultController;
class ScriptState;

class CORE_EXPORT V8UnionReadableByteStreamControllerOrReadableStreamDefaultController final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kReadableByteStreamController, kReadableStreamDefaultController
};

static V8UnionReadableByteStreamControllerOrReadableStreamDefaultController* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionReadableByteStreamControllerOrReadableStreamDefaultController(ReadableByteStreamController* value) : content_type_(ContentType::kReadableByteStreamController), member_readable_byte_stream_controller_(value) {
  DCHECK(value);
}
explicit  V8UnionReadableByteStreamControllerOrReadableStreamDefaultController(ReadableStreamDefaultController* value) : content_type_(ContentType::kReadableStreamDefaultController), member_readable_stream_default_controller_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsReadableByteStreamController() const {
  return content_type_ == ContentType::kReadableByteStreamController;
}
ReadableByteStreamController* GetAsReadableByteStreamController() const {
  DCHECK_EQ(content_type_, ContentType::kReadableByteStreamController);
return member_readable_byte_stream_controller_.Get();
}
void Set(ReadableByteStreamController* value) {
  DCHECK(value);
Clear();
member_readable_byte_stream_controller_ = value;
content_type_ = ContentType::kReadableByteStreamController;
}

bool IsReadableStreamDefaultController() const {
  return content_type_ == ContentType::kReadableStreamDefaultController;
}
ReadableStreamDefaultController* GetAsReadableStreamDefaultController() const {
  DCHECK_EQ(content_type_, ContentType::kReadableStreamDefaultController);
return member_readable_stream_default_controller_.Get();
}
void Set(ReadableStreamDefaultController* value) {
  DCHECK(value);
Clear();
member_readable_stream_default_controller_ = value;
content_type_ = ContentType::kReadableStreamDefaultController;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ReadableByteStreamController or ReadableStreamDefaultController)";
}

ContentType content_type_;

Member<ReadableByteStreamController> member_readable_byte_stream_controller_;
Member<ReadableStreamDefaultController> member_readable_stream_default_controller_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_READABLEBYTESTREAMCONTROLLER_READABLESTREAMDEFAULTCONTROLLER_H_
