// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLSCRIPTELEMENT_SVGSCRIPTELEMENT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLSCRIPTELEMENT_SVGSCRIPTELEMENT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLScriptElement;
class SVGScriptElement;
class ScriptState;

class CORE_EXPORT V8UnionHTMLScriptElementOrSVGScriptElement final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLScriptElement, kSVGScriptElement
};

static V8UnionHTMLScriptElementOrSVGScriptElement* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLScriptElementOrSVGScriptElement(HTMLScriptElement* value) : content_type_(ContentType::kHTMLScriptElement), member_html_script_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLScriptElementOrSVGScriptElement(SVGScriptElement* value) : content_type_(ContentType::kSVGScriptElement), member_svg_script_element_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLScriptElement() const {
  return content_type_ == ContentType::kHTMLScriptElement;
}
HTMLScriptElement* GetAsHTMLScriptElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLScriptElement);
return member_html_script_element_.Get();
}
void Set(HTMLScriptElement* value) {
  DCHECK(value);
Clear();
member_html_script_element_ = value;
content_type_ = ContentType::kHTMLScriptElement;
}

bool IsSVGScriptElement() const {
  return content_type_ == ContentType::kSVGScriptElement;
}
SVGScriptElement* GetAsSVGScriptElement() const {
  DCHECK_EQ(content_type_, ContentType::kSVGScriptElement);
return member_svg_script_element_.Get();
}
void Set(SVGScriptElement* value) {
  DCHECK(value);
Clear();
member_svg_script_element_ = value;
content_type_ = ContentType::kSVGScriptElement;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLScriptElement or SVGScriptElement)";
}

ContentType content_type_;

Member<HTMLScriptElement> member_html_script_element_;
Member<SVGScriptElement> member_svg_script_element_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_HTMLSCRIPTELEMENT_SVGSCRIPTELEMENT_H_
