// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_element_radionodelist.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_radio_node_list.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/html/forms/radio_node_list.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionElementOrRadioNodeList* V8UnionElementOrRadioNodeList::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8Element::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Element::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionElementOrRadioNodeList>(blink_value);
}
if (V8RadioNodeList::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8RadioNodeList::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionElementOrRadioNodeList>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionElementOrRadioNodeList::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kElement: {
    return ToV8Traits<Element>::ToV8(script_state, member_element_.Get());
  }
  case ContentType::kRadioNodeList: {
    return ToV8Traits<RadioNodeList>::ToV8(script_state, member_radio_node_list_.Get());
  }
}

NOTREACHED();
}

void V8UnionElementOrRadioNodeList::Trace(Visitor* visitor) const {
  visitor->Trace(member_element_);
visitor->Trace(member_radio_node_list_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionElementOrRadioNodeList::Clear() {
  member_element_.Clear();
member_radio_node_list_.Clear();
}



}  // namespace blink
