// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_documenttimeline_scrolltimeline.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_document_timeline.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_scroll_timeline.h"
#include "third_party/blink/renderer/core/animation/document_timeline.h"
#include "third_party/blink/renderer/core/animation/scroll_timeline.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDocumentTimelineOrScrollTimeline* V8UnionDocumentTimelineOrScrollTimeline::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8ScrollTimeline::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ScrollTimeline::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionDocumentTimelineOrScrollTimeline>(blink_value);
}
if (V8DocumentTimeline::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8DocumentTimeline::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionDocumentTimelineOrScrollTimeline>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










void V8UnionDocumentTimelineOrScrollTimeline::Trace(Visitor* visitor) const {
  visitor->Trace(member_document_timeline_);
visitor->Trace(member_scroll_timeline_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionDocumentTimelineOrScrollTimeline::Clear() {
  member_document_timeline_.Clear();
member_scroll_timeline_.Clear();
}



}  // namespace blink
