// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_childnodepart_documentpartroot.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_child_node_part.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_document_part_root.h"
#include "third_party/blink/renderer/core/dom/child_node_part.h"
#include "third_party/blink/renderer/core/dom/document_part_root.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionChildNodePartOrDocumentPartRoot* V8UnionChildNodePartOrDocumentPartRoot::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8ChildNodePart::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ChildNodePart::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionChildNodePartOrDocumentPartRoot>(blink_value);
}
if (V8DocumentPartRoot::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8DocumentPartRoot::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionChildNodePartOrDocumentPartRoot>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionChildNodePartOrDocumentPartRoot::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kChildNodePart: {
    return ToV8Traits<ChildNodePart>::ToV8(script_state, member_child_node_part_.Get());
  }
  case ContentType::kDocumentPartRoot: {
    return ToV8Traits<DocumentPartRoot>::ToV8(script_state, member_document_part_root_.Get());
  }
}

NOTREACHED();
}

void V8UnionChildNodePartOrDocumentPartRoot::Trace(Visitor* visitor) const {
  visitor->Trace(member_child_node_part_);
visitor->Trace(member_document_part_root_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionChildNodePartOrDocumentPartRoot::Clear() {
  member_child_node_part_.Clear();
member_document_part_root_.Clear();
}



}  // namespace blink
