// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_medialist.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_media_list.h"
#include "third_party/blink/renderer/core/css/media_list.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionBooleanOrMediaList* V8UnionBooleanOrMediaList::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8MediaList::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MediaList::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionBooleanOrMediaList>(blink_value);
}
if (v8_value->IsBoolean()) {
  auto&& blink_value = v8_value.As<v8::Boolean>()->Value();
return MakeGarbageCollected<V8UnionBooleanOrMediaList>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLBoolean>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrMediaList>(blink_value);
}
}










v8::Local<v8::Value> V8UnionBooleanOrMediaList::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return ToV8Traits<IDLBoolean>::ToV8(script_state, member_boolean_);
  }
  case ContentType::kMediaList: {
    return ToV8Traits<MediaList>::ToV8(script_state, member_media_list_.Get());
  }
}

NOTREACHED();
}

void V8UnionBooleanOrMediaList::Trace(Visitor* visitor) const {
  visitor->Trace(member_media_list_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionBooleanOrMediaList::Clear() {
  member_boolean_ = false;
member_media_list_.Clear();
}



}  // namespace blink
