// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUTOKEYWORD_DOUBLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUTOKEYWORD_DOUBLE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_auto_keyword.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionAutoKeywordOrDouble final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAutoKeyword, kDouble
};

static V8UnionAutoKeywordOrDouble* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAutoKeywordOrDouble(V8AutoKeyword value) : content_type_(ContentType::kAutoKeyword), member_auto_keyword_(value) {
  
}
explicit  V8UnionAutoKeywordOrDouble(double value) : content_type_(ContentType::kDouble), member_double_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAutoKeyword() const {
  return content_type_ == ContentType::kAutoKeyword;
}
V8AutoKeyword GetAsAutoKeyword() const {
  DCHECK_EQ(content_type_, ContentType::kAutoKeyword);
return member_auto_keyword_;
}
void Set(V8AutoKeyword value) {
  Clear();
member_auto_keyword_ = value;
content_type_ = ContentType::kAutoKeyword;
}

bool IsDouble() const {
  return content_type_ == ContentType::kDouble;
}
double GetAsDouble() const {
  DCHECK_EQ(content_type_, ContentType::kDouble);
return member_double_;
}
void Set(double value) {
  Clear();
member_double_ = value;
content_type_ = ContentType::kDouble;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AutoKeyword or double)";
}

ContentType content_type_;

V8AutoKeyword member_auto_keyword_{static_cast<V8AutoKeyword::Enum>(0)};
double member_double_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_AUTOKEYWORD_DOUBLE_H_
