// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_string.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferOrArrayBufferViewOrString* V8UnionArrayBufferOrArrayBufferViewOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(std::move(blink_value));
}
}

 V8UnionArrayBufferOrArrayBufferViewOrString::V8UnionArrayBufferOrArrayBufferViewOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionArrayBufferOrArrayBufferViewOrString::V8UnionArrayBufferOrArrayBufferViewOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}










void V8UnionArrayBufferOrArrayBufferViewOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionArrayBufferOrArrayBufferViewOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}




V8UnionArrayBufferOrArrayBufferView* V8UnionArrayBufferOrArrayBufferViewOrString::GetAsV8UnionArrayBufferOrArrayBufferView() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBufferView());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrString::Set(const V8UnionArrayBufferOrArrayBufferView* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
}
}






V8UnionArrayBufferOrString* V8UnionArrayBufferOrArrayBufferViewOrString::GetAsV8UnionArrayBufferOrString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrString>(GetAsArrayBuffer());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionArrayBufferOrArrayBufferViewOrString::Set(const V8UnionArrayBufferOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


void V8UnionArrayBufferOrArrayBufferViewOrString::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
visitor->Trace(member_array_buffer_view_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferOrArrayBufferViewOrString::Clear() {
  member_array_buffer_.Clear();
member_array_buffer_view_.Clear();
member_string_ = String();
}



}  // namespace blink
