// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ANIMATIONEFFECT_ANIMATIONEFFECTSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ANIMATIONEFFECT_ANIMATIONEFFECTSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AnimationEffect;
class ExceptionState;
class ScriptState;

class CORE_EXPORT V8UnionAnimationEffectOrAnimationEffectSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAnimationEffect, kAnimationEffectSequence
};

static V8UnionAnimationEffectOrAnimationEffectSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAnimationEffectOrAnimationEffectSequence(AnimationEffect* value) : content_type_(ContentType::kAnimationEffect), member_animation_effect_(value) {
  DCHECK(value);
}
explicit  V8UnionAnimationEffectOrAnimationEffectSequence(const HeapVector<Member<AnimationEffect>>& value);
explicit  V8UnionAnimationEffectOrAnimationEffectSequence(HeapVector<Member<AnimationEffect>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAnimationEffect() const {
  return content_type_ == ContentType::kAnimationEffect;
}
AnimationEffect* GetAsAnimationEffect() const {
  DCHECK_EQ(content_type_, ContentType::kAnimationEffect);
return member_animation_effect_.Get();
}
void Set(AnimationEffect* value) {
  DCHECK(value);
Clear();
member_animation_effect_ = value;
content_type_ = ContentType::kAnimationEffect;
}

bool IsAnimationEffectSequence() const {
  return content_type_ == ContentType::kAnimationEffectSequence;
}
const HeapVector<Member<AnimationEffect>>& GetAsAnimationEffectSequence() const {
  DCHECK_EQ(content_type_, ContentType::kAnimationEffectSequence);
return member_animation_effect_sequence_;
}
void Set(const HeapVector<Member<AnimationEffect>>& value);
void Set(HeapVector<Member<AnimationEffect>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AnimationEffect or sequence<AnimationEffect>)";
}

ContentType content_type_;

Member<AnimationEffect> member_animation_effect_;
HeapVector<Member<AnimationEffect>> member_animation_effect_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_UNION_ANIMATIONEFFECT_ANIMATIONEFFECTSEQUENCE_H_
