// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_ui_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/frame/dom_window.h"
#include "third_party/blink/renderer/core/input/input_device_capabilities.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"detail",
"sourceCapabilities",
"view",
};


}  // namespace 

UIEventInit* UIEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  UIEventInit* dictionary = MakeGarbageCollected<UIEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "UIEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 UIEventInit::UIEventInit() {
  
}

 UIEventInit::UIEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}


















void UIEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_source_capabilities_);
visitor->Trace(member_view_);
EventInit::Trace(visitor);
}

void UIEventInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  EventInit::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void UIEventInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  EventInit::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDetail()) {
  values[0] = ToV8Traits<IDLLong>::ToV8(script_state, member_detail_);
DCHECK(!values[0].IsEmpty());
}
if (hasSourceCapabilities()) {
  values[1] = ToV8Traits<IDLNullable<InputDeviceCapabilities>>::ToV8(script_state, member_source_capabilities_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasView()) {
  values[2] = ToV8Traits<IDLNullable<DOMWindow>>::ToV8(script_state, member_view_.Get());
DCHECK(!values[2].IsEmpty());
}
}

const void* UIEventInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> UIEventInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void UIEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "UIEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("detail");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_detail_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sourceCapabilities");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<InputDeviceCapabilities>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_source_capabilities_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("view");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<DOMWindow>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_view_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> UIEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
