// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRUSTED_TYPE_POLICY_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRUSTED_TYPE_POLICY_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class V8CreateHTMLCallback;
class V8CreateScriptCallback;
class V8CreateURLCallback;

class CORE_EXPORT TrustedTypePolicyOptions : public bindings::InputDictionaryBase {
  
  public:
static TrustedTypePolicyOptions* Create() {
  return MakeGarbageCollected<TrustedTypePolicyOptions>();
}
static TrustedTypePolicyOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TrustedTypePolicyOptions>(isolate);
}
static TrustedTypePolicyOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TrustedTypePolicyOptions();
explicit  TrustedTypePolicyOptions(v8::Isolate* isolate);

bool hasCreateHTML() const {
  return has_create_html_;
}
V8CreateHTMLCallback* createHTML() const {
  DCHECK(hasCreateHTML());
return member_create_html_.Get();
}
V8CreateHTMLCallback* getCreateHTMLOr(V8CreateHTMLCallback* fallback_value) const {
  if (!hasCreateHTML()) {
  return fallback_value;
}
return member_create_html_.Get();
}
void setCreateHTML(V8CreateHTMLCallback* value) {
  member_create_html_ = value;
has_create_html_ = true;
DCHECK(member_create_html_);
}

bool hasCreateScript() const {
  return has_create_script_;
}
V8CreateScriptCallback* createScript() const {
  DCHECK(hasCreateScript());
return member_create_script_.Get();
}
V8CreateScriptCallback* getCreateScriptOr(V8CreateScriptCallback* fallback_value) const {
  if (!hasCreateScript()) {
  return fallback_value;
}
return member_create_script_.Get();
}
void setCreateScript(V8CreateScriptCallback* value) {
  member_create_script_ = value;
has_create_script_ = true;
DCHECK(member_create_script_);
}

bool hasCreateScriptURL() const {
  return has_create_script_url_;
}
V8CreateURLCallback* createScriptURL() const {
  DCHECK(hasCreateScriptURL());
return member_create_script_url_.Get();
}
V8CreateURLCallback* getCreateScriptURLOr(V8CreateURLCallback* fallback_value) const {
  if (!hasCreateScriptURL()) {
  return fallback_value;
}
return member_create_script_url_.Get();
}
void setCreateScriptURL(V8CreateURLCallback* value) {
  member_create_script_url_ = value;
has_create_script_url_ = true;
DCHECK(member_create_script_url_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_create_html_ = false;
bool has_create_script_ = false;
bool has_create_script_url_ = false;

Member<V8CreateHTMLCallback> member_create_html_;
Member<V8CreateScriptCallback> member_create_script_;
Member<V8CreateURLCallback> member_create_script_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TRUSTED_TYPE_POLICY_OPTIONS_H_
