// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class EventTarget;
class ExceptionState;

class CORE_EXPORT TouchInit : public bindings::InputDictionaryBase {
  
  public:
static TouchInit* Create() {
  return MakeGarbageCollected<TouchInit>();
}
static TouchInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TouchInit>(isolate);
}
static TouchInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TouchInit();
explicit  TouchInit(v8::Isolate* isolate);

bool hasClientX() const {
  return true;
}
double clientX() const {
  return member_client_x_;
}
void setClientX(double value) {
  member_client_x_ = value;
}

bool hasClientY() const {
  return true;
}
double clientY() const {
  return member_client_y_;
}
void setClientY(double value) {
  member_client_y_ = value;
}

bool hasForce() const {
  return true;
}
float force() const {
  return member_force_;
}
void setForce(float value) {
  member_force_ = value;
}

bool hasIdentifier() const {
  return true;
}
int32_t identifier() const {
  return member_identifier_;
}
void setIdentifier(int32_t value) {
  member_identifier_ = value;
}

bool hasPageX() const {
  return true;
}
double pageX() const {
  return member_page_x_;
}
void setPageX(double value) {
  member_page_x_ = value;
}

bool hasPageY() const {
  return true;
}
double pageY() const {
  return member_page_y_;
}
void setPageY(double value) {
  member_page_y_ = value;
}

bool hasRadiusX() const {
  return true;
}
float radiusX() const {
  return member_radius_x_;
}
void setRadiusX(float value) {
  member_radius_x_ = value;
}

bool hasRadiusY() const {
  return true;
}
float radiusY() const {
  return member_radius_y_;
}
void setRadiusY(float value) {
  member_radius_y_ = value;
}

bool hasRotationAngle() const {
  return true;
}
float rotationAngle() const {
  return member_rotation_angle_;
}
void setRotationAngle(float value) {
  member_rotation_angle_ = value;
}

bool hasScreenX() const {
  return true;
}
double screenX() const {
  return member_screen_x_;
}
void setScreenX(double value) {
  member_screen_x_ = value;
}

bool hasScreenY() const {
  return true;
}
double screenY() const {
  return member_screen_y_;
}
void setScreenY(double value) {
  member_screen_y_ = value;
}

bool hasTarget() const {
  return true;
}
EventTarget* target() const {
  return member_target_.Get();
}
void setTarget(EventTarget* value) {
  member_target_ = value;
DCHECK(member_target_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 12;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



double member_client_x_{0};
double member_client_y_{0};
float member_force_{0};
int32_t member_identifier_;
double member_page_x_{0};
double member_page_y_{0};
float member_radius_x_{0};
float member_radius_y_{0};
float member_rotation_angle_{0};
double member_screen_x_{0};
double member_screen_y_{0};
Member<EventTarget> member_target_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_INIT_H_
