// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_modifier_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Touch;

class CORE_EXPORT TouchEventInit : public EventModifierInit {
  
  public:
static TouchEventInit* Create() {
  return MakeGarbageCollected<TouchEventInit>();
}
static TouchEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<TouchEventInit>(isolate);
}
static TouchEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  TouchEventInit();
explicit  TouchEventInit(v8::Isolate* isolate);

bool hasChangedTouches() const {
  return true;
}
const HeapVector<Member<Touch>>& changedTouches() const {
  return member_changed_touches_;
}
void setChangedTouches(const HeapVector<Member<Touch>>& value);
void setChangedTouches(HeapVector<Member<Touch>>&& value);

bool hasTargetTouches() const {
  return true;
}
const HeapVector<Member<Touch>>& targetTouches() const {
  return member_target_touches_;
}
void setTargetTouches(const HeapVector<Member<Touch>>& value);
void setTargetTouches(HeapVector<Member<Touch>>&& value);

bool hasTouches() const {
  return true;
}
const HeapVector<Member<Touch>>& touches() const {
  return member_touches_;
}
void setTouches(const HeapVector<Member<Touch>>& value);
void setTouches(HeapVector<Member<Touch>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventModifierInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<Touch>> member_changed_touches_;
HeapVector<Member<Touch>> member_target_touches_;
HeapVector<Member<Touch>> member_touches_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_TOUCH_EVENT_INIT_H_
