// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_text_directive_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"prefix",
"suffix",
"textEnd",
"textStart",
};


}  // namespace 

TextDirectiveOptions* TextDirectiveOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  TextDirectiveOptions* dictionary = MakeGarbageCollected<TextDirectiveOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "TextDirectiveOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 TextDirectiveOptions::TextDirectiveOptions() {
  
}

 TextDirectiveOptions::TextDirectiveOptions(v8::Isolate* isolate) {
  
}



String TextDirectiveOptions::getPrefixOr(const String& fallback_value) const {
  if (!hasPrefix()) {
  return fallback_value;
}
return member_prefix_;
}

String TextDirectiveOptions::getPrefixOr(String&& fallback_value) const {
  if (!hasPrefix()) {
  return std::move(fallback_value);
}
return member_prefix_;
}

void TextDirectiveOptions::setPrefix(const String& value) {
  member_prefix_ = value;
has_prefix_ = true;
}

void TextDirectiveOptions::setPrefix(String&& value) {
  member_prefix_ = std::move(value);
has_prefix_ = true;
}




String TextDirectiveOptions::getSuffixOr(const String& fallback_value) const {
  if (!hasSuffix()) {
  return fallback_value;
}
return member_suffix_;
}

String TextDirectiveOptions::getSuffixOr(String&& fallback_value) const {
  if (!hasSuffix()) {
  return std::move(fallback_value);
}
return member_suffix_;
}

void TextDirectiveOptions::setSuffix(const String& value) {
  member_suffix_ = value;
has_suffix_ = true;
}

void TextDirectiveOptions::setSuffix(String&& value) {
  member_suffix_ = std::move(value);
has_suffix_ = true;
}




String TextDirectiveOptions::getTextEndOr(const String& fallback_value) const {
  if (!hasTextEnd()) {
  return fallback_value;
}
return member_text_end_;
}

String TextDirectiveOptions::getTextEndOr(String&& fallback_value) const {
  if (!hasTextEnd()) {
  return std::move(fallback_value);
}
return member_text_end_;
}

void TextDirectiveOptions::setTextEnd(const String& value) {
  member_text_end_ = value;
has_text_end_ = true;
}

void TextDirectiveOptions::setTextEnd(String&& value) {
  member_text_end_ = std::move(value);
has_text_end_ = true;
}




String TextDirectiveOptions::getTextStartOr(const String& fallback_value) const {
  if (!hasTextStart()) {
  return fallback_value;
}
return member_text_start_;
}

String TextDirectiveOptions::getTextStartOr(String&& fallback_value) const {
  if (!hasTextStart()) {
  return std::move(fallback_value);
}
return member_text_start_;
}

void TextDirectiveOptions::setTextStart(const String& value) {
  member_text_start_ = value;
has_text_start_ = true;
}

void TextDirectiveOptions::setTextStart(String&& value) {
  member_text_start_ = std::move(value);
has_text_start_ = true;
}




void TextDirectiveOptions::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void TextDirectiveOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "TextDirectiveOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("prefix");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_prefix_, member_prefix_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("suffix");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_suffix_, member_suffix_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("textEnd");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_text_end_, member_text_end_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("textStart");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_text_start_, member_text_start_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> TextDirectiveOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
