// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STREAM_PIPE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STREAM_PIPE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbortSignal;
class ExceptionState;

class CORE_EXPORT StreamPipeOptions : public bindings::InputDictionaryBase {
  
  public:
static StreamPipeOptions* Create() {
  return MakeGarbageCollected<StreamPipeOptions>();
}
static StreamPipeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StreamPipeOptions>(isolate);
}
static StreamPipeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StreamPipeOptions();
explicit  StreamPipeOptions(v8::Isolate* isolate);

bool hasPreventAbort() const {
  return true;
}
bool preventAbort() const {
  return member_prevent_abort_;
}
void setPreventAbort(bool value) {
  member_prevent_abort_ = value;
}

bool hasPreventCancel() const {
  return true;
}
bool preventCancel() const {
  return member_prevent_cancel_;
}
void setPreventCancel(bool value) {
  member_prevent_cancel_ = value;
}

bool hasPreventClose() const {
  return true;
}
bool preventClose() const {
  return member_prevent_close_;
}
void setPreventClose(bool value) {
  member_prevent_close_ = value;
}

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_signal_ = false;

bool member_prevent_abort_{false};
bool member_prevent_cancel_{false};
bool member_prevent_close_{false};
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STREAM_PIPE_OPTIONS_H_
