// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STATIC_RANGE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STATIC_RANGE_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Node;

class CORE_EXPORT StaticRangeInit : public bindings::InputDictionaryBase {
  
  public:
static StaticRangeInit* Create() {
  return MakeGarbageCollected<StaticRangeInit>();
}
static StaticRangeInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<StaticRangeInit>(isolate);
}
static StaticRangeInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  StaticRangeInit();
explicit  StaticRangeInit(v8::Isolate* isolate);

bool hasEndContainer() const {
  return true;
}
Node* endContainer() const {
  return member_end_container_.Get();
}
void setEndContainer(Node* value) {
  member_end_container_ = value;
DCHECK(member_end_container_);
}

bool hasEndOffset() const {
  return true;
}
uint32_t endOffset() const {
  return member_end_offset_;
}
void setEndOffset(uint32_t value) {
  member_end_offset_ = value;
}

bool hasStartContainer() const {
  return true;
}
Node* startContainer() const {
  return member_start_container_.Get();
}
void setStartContainer(Node* value) {
  member_start_container_ = value;
DCHECK(member_start_container_);
}

bool hasStartOffset() const {
  return true;
}
uint32_t startOffset() const {
  return member_start_offset_;
}
void setStartOffset(uint32_t value) {
  member_start_offset_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<Node> member_end_container_;
uint32_t member_end_offset_;
Member<Node> member_start_container_;
uint32_t member_start_offset_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_STATIC_RANGE_INIT_H_
