// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_security_policy_violation_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"blockedURI",
"columnNumber",
"disposition",
"documentURI",
"effectiveDirective",
"evalHash",
"lineNumber",
"originalPolicy",
"referrer",
"sample",
"sourceFile",
"statusCode",
"violatedDirective",
};


}  // namespace 

SecurityPolicyViolationEventInit* SecurityPolicyViolationEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SecurityPolicyViolationEventInit* dictionary = MakeGarbageCollected<SecurityPolicyViolationEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SecurityPolicyViolationEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SecurityPolicyViolationEventInit::SecurityPolicyViolationEventInit() {
  
}

 SecurityPolicyViolationEventInit::SecurityPolicyViolationEventInit(v8::Isolate* isolate) : EventInit(isolate) {
  
}



void SecurityPolicyViolationEventInit::setBlockedURI(const String& value) {
  member_blocked_uri_ = value;
}

void SecurityPolicyViolationEventInit::setBlockedURI(String&& value) {
  member_blocked_uri_ = std::move(value);
}














void SecurityPolicyViolationEventInit::setDocumentURI(const String& value) {
  member_document_uri_ = value;
}

void SecurityPolicyViolationEventInit::setDocumentURI(String&& value) {
  member_document_uri_ = std::move(value);
}




void SecurityPolicyViolationEventInit::setEffectiveDirective(const String& value) {
  member_effective_directive_ = value;
}

void SecurityPolicyViolationEventInit::setEffectiveDirective(String&& value) {
  member_effective_directive_ = std::move(value);
}




String SecurityPolicyViolationEventInit::getEvalHashOr(const String& fallback_value) const {
  if (!hasEvalHash()) {
  return fallback_value;
}
return member_eval_hash_;
}

String SecurityPolicyViolationEventInit::getEvalHashOr(String&& fallback_value) const {
  if (!hasEvalHash()) {
  return std::move(fallback_value);
}
return member_eval_hash_;
}

void SecurityPolicyViolationEventInit::setEvalHash(const String& value) {
  member_eval_hash_ = value;
has_eval_hash_ = true;
}

void SecurityPolicyViolationEventInit::setEvalHash(String&& value) {
  member_eval_hash_ = std::move(value);
has_eval_hash_ = true;
}









void SecurityPolicyViolationEventInit::setOriginalPolicy(const String& value) {
  member_original_policy_ = value;
}

void SecurityPolicyViolationEventInit::setOriginalPolicy(String&& value) {
  member_original_policy_ = std::move(value);
}




void SecurityPolicyViolationEventInit::setReferrer(const String& value) {
  member_referrer_ = value;
}

void SecurityPolicyViolationEventInit::setReferrer(String&& value) {
  member_referrer_ = std::move(value);
}




void SecurityPolicyViolationEventInit::setSample(const String& value) {
  member_sample_ = value;
}

void SecurityPolicyViolationEventInit::setSample(String&& value) {
  member_sample_ = std::move(value);
}




void SecurityPolicyViolationEventInit::setSourceFile(const String& value) {
  member_source_file_ = value;
}

void SecurityPolicyViolationEventInit::setSourceFile(String&& value) {
  member_source_file_ = std::move(value);
}









void SecurityPolicyViolationEventInit::setViolatedDirective(const String& value) {
  member_violated_directive_ = value;
}

void SecurityPolicyViolationEventInit::setViolatedDirective(String&& value) {
  member_violated_directive_ = std::move(value);
}




void SecurityPolicyViolationEventInit::Trace(Visitor* visitor) const {
  EventInit::Trace(visitor);
}

void SecurityPolicyViolationEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
EventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "SecurityPolicyViolationEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("blockedURI");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_blocked_uri_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("columnNumber");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_column_number_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("disposition");
if (!bindings::GetDictionaryMemberFromV8Object<V8SecurityPolicyViolationEventDisposition, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_disposition_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("documentURI");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_document_uri_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("effectiveDirective");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_effective_directive_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::CSPHashesV1Enabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("evalHash");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_eval_hash_, member_eval_hash_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("lineNumber");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_line_number_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("originalPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_original_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("referrer");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_referrer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sample");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_sample_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sourceFile");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_source_file_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("statusCode");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedShort, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), fallback_presence_var, member_status_code_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("violatedDirective");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_violated_directive_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SecurityPolicyViolationEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
