// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_ELEMENT_NAMESPACE_WITH_ATTRIBUTES_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_ELEMENT_NAMESPACE_WITH_ATTRIBUTES_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_sanitizer_element_namespace.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class SanitizerAttributeNamespace;
class V8UnionSanitizerAttributeNamespaceOrString;

class CORE_EXPORT SanitizerElementNamespaceWithAttributes : public SanitizerElementNamespace {
  
  public:
static SanitizerElementNamespaceWithAttributes* Create() {
  return MakeGarbageCollected<SanitizerElementNamespaceWithAttributes>();
}
static SanitizerElementNamespaceWithAttributes* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SanitizerElementNamespaceWithAttributes>(isolate);
}
static SanitizerElementNamespaceWithAttributes* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SanitizerElementNamespaceWithAttributes();
explicit  SanitizerElementNamespaceWithAttributes(v8::Isolate* isolate);

bool hasAttributes() const {
  return has_attributes_;
}
const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& attributes() const {
  DCHECK(hasAttributes());
return member_attributes_;
}
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const;
void setAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value);
void setAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value);

bool hasRemoveAttributes() const {
  return has_remove_attributes_;
}
const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& removeAttributes() const {
  DCHECK(hasRemoveAttributes());
return member_remove_attributes_;
}
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getRemoveAttributesOr(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& fallback_value) const;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> getRemoveAttributesOr(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& fallback_value) const;
void setRemoveAttributes(const HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>& value);
void setRemoveAttributes(HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>>&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = SanitizerElementNamespace::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_attributes_ = false;
bool has_remove_attributes_ = false;

HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> member_attributes_;
HeapVector<Member<V8UnionSanitizerAttributeNamespaceOrString>> member_remove_attributes_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_SANITIZER_ELEMENT_NAMESPACE_WITH_ATTRIBUTES_H_
