// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESIZE_OBSERVER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESIZE_OBSERVER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_resize_observer_box_options.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ResizeObserverOptions : public bindings::InputDictionaryBase {
  
  public:
static ResizeObserverOptions* Create() {
  return MakeGarbageCollected<ResizeObserverOptions>();
}
static ResizeObserverOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ResizeObserverOptions>(isolate);
}
static ResizeObserverOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ResizeObserverOptions();
explicit  ResizeObserverOptions(v8::Isolate* isolate);

bool hasBox() const {
  return true;
}
V8ResizeObserverBoxOptions box() const {
  return member_box_;
}
void setBox(V8ResizeObserverBoxOptions value) {
  member_box_ = value;
}
void setBox(V8ResizeObserverBoxOptions::Enum value) {
  member_box_ = V8ResizeObserverBoxOptions(value);
}

bool hasFireOnEveryPaint() const {
  return true;
}
bool fireOnEveryPaint() const {
  return member_fire_on_every_paint_;
}
void setFireOnEveryPaint(bool value) {
  member_fire_on_every_paint_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8ResizeObserverBoxOptions member_box_{V8ResizeObserverBoxOptions::Enum::kContentBox};
bool member_fire_on_every_paint_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESIZE_OBSERVER_OPTIONS_H_
