// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_reducer.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8Reducer::GetHumanReadableName() const {
  return "V8Reducer";
}

v8::Maybe<ScriptValue> V8Reducer::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const ScriptValue& arg1_accumulator, const ScriptValue& arg2_current_value, uint64_t arg3_index) {
  const char* const class_like_name = "Reducer";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptValue>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptValue>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}
v8::Local<v8::Value> argv_arr[3];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_accumulator;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_accumulator = ToV8Traits<IDLAny>::ToV8(script_state, arg1_accumulator);
argv[0] = v8_arg1_accumulator;
v8::Local<v8::Value> v8_arg2_current_value;
v8_arg2_current_value = ToV8Traits<IDLAny>::ToV8(script_state, arg2_current_value);
argv[1] = v8_arg2_current_value;
v8::Local<v8::Value> v8_arg3_index;
v8_arg3_index = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, arg3_index);
argv[2] = v8_arg3_index;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}

v8::Maybe<ScriptValue> V8Reducer::Construct(const ScriptValue& arg1_accumulator, const ScriptValue& arg2_current_value, uint64_t arg3_index) {
  const char* const class_like_name = "Reducer";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptValue>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptValue>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}
v8::Local<v8::Value> argv_arr[3];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_accumulator;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_accumulator = ToV8Traits<IDLAny>::ToV8(script_state, arg1_accumulator);
argv[0] = v8_arg1_accumulator;
v8::Local<v8::Value> v8_arg2_current_value;
v8_arg2_current_value = ToV8Traits<IDLAny>::ToV8(script_state, arg2_current_value);
argv[1] = v8_arg2_current_value;
v8::Local<v8::Value> v8_arg3_index;
v8_arg3_index = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, arg3_index);
argv[2] = v8_arg3_index;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}




}  // namespace blink
