// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_WRITABLE_PAIR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_WRITABLE_PAIR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ReadableStream;
class WritableStream;

class CORE_EXPORT ReadableWritablePair : public bindings::InputDictionaryBase {
  
  public:
static ReadableWritablePair* Create() {
  return MakeGarbageCollected<ReadableWritablePair>();
}
static ReadableWritablePair* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ReadableWritablePair>(isolate);
}
static ReadableWritablePair* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ReadableWritablePair();
explicit  ReadableWritablePair(v8::Isolate* isolate);

bool hasReadable() const {
  return true;
}
ReadableStream* readable() const {
  return member_readable_.Get();
}
void setReadable(ReadableStream* value) {
  member_readable_ = value;
DCHECK(member_readable_);
}

bool hasWritable() const {
  return true;
}
WritableStream* writable() const {
  return member_writable_.Get();
}
void setWritable(WritableStream* value) {
  member_writable_ = value;
DCHECK(member_writable_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<ReadableStream> member_readable_;
Member<WritableStream> member_writable_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_READABLE_WRITABLE_PAIR_H_
