// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_trace.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_frame.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_sample.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_stack.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"frames",
"resources",
"samples",
"stacks",
};


}  // namespace 

ProfilerTrace* ProfilerTrace::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ProfilerTrace* dictionary = MakeGarbageCollected<ProfilerTrace>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ProfilerTrace";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ProfilerTrace::ProfilerTrace() {
  
}

 ProfilerTrace::ProfilerTrace(v8::Isolate* isolate) {
  
}



void ProfilerTrace::setFrames(const HeapVector<Member<ProfilerFrame>>& value) {
  member_frames_ = value;
}

void ProfilerTrace::setFrames(HeapVector<Member<ProfilerFrame>>&& value) {
  member_frames_ = std::move(value);
}




void ProfilerTrace::setResources(const Vector<String>& value) {
  member_resources_ = value;
}

void ProfilerTrace::setResources(Vector<String>&& value) {
  member_resources_ = std::move(value);
}




void ProfilerTrace::setSamples(const HeapVector<Member<ProfilerSample>>& value) {
  member_samples_ = value;
}

void ProfilerTrace::setSamples(HeapVector<Member<ProfilerSample>>&& value) {
  member_samples_ = std::move(value);
}




void ProfilerTrace::setStacks(const HeapVector<Member<ProfilerStack>>& value) {
  member_stacks_ = value;
}

void ProfilerTrace::setStacks(HeapVector<Member<ProfilerStack>>&& value) {
  member_stacks_ = std::move(value);
}




void ProfilerTrace::Trace(Visitor* visitor) const {
  visitor->Trace(member_frames_);
visitor->Trace(member_samples_);
visitor->Trace(member_stacks_);
bindings::DictionaryBase::Trace(visitor);
}

void ProfilerTrace::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void ProfilerTrace::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasFrames()) {
  values[0] = ToV8Traits<IDLSequence<ProfilerFrame>>::ToV8(script_state, member_frames_);
DCHECK(!values[0].IsEmpty());
}
if (hasResources()) {
  values[1] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_resources_);
DCHECK(!values[1].IsEmpty());
}
if (hasSamples()) {
  values[2] = ToV8Traits<IDLSequence<ProfilerSample>>::ToV8(script_state, member_samples_);
DCHECK(!values[2].IsEmpty());
}
if (hasStacks()) {
  values[3] = ToV8Traits<IDLSequence<ProfilerStack>>::ToV8(script_state, member_stacks_);
DCHECK(!values[3].IsEmpty());
}
}

const void* ProfilerTrace::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> ProfilerTrace::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void ProfilerTrace::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ProfilerTrace";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("frames");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ProfilerFrame>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_frames_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resources");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_resources_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("samples");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ProfilerSample>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_samples_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stacks");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<ProfilerStack>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_stacks_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ProfilerTrace::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
