// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_SAMPLE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_SAMPLE_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_profiler_marker.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ProfilerSample : public bindings::DictionaryBase {
  
  public:
static ProfilerSample* Create() {
  return MakeGarbageCollected<ProfilerSample>();
}
static ProfilerSample* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProfilerSample>(isolate);
}
static ProfilerSample* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProfilerSample();
explicit  ProfilerSample(v8::Isolate* isolate);

bool hasMarker() const {
  return has_marker_;
}
V8ProfilerMarker marker() const {
  DCHECK(hasMarker());
return member_marker_;
}
V8ProfilerMarker getMarkerOr(V8ProfilerMarker fallback_value) const {
  if (!hasMarker()) {
  return fallback_value;
}
return member_marker_;
}
void setMarker(V8ProfilerMarker value) {
  member_marker_ = value;
has_marker_ = true;
}
void setMarker(V8ProfilerMarker::Enum value) {
  member_marker_ = V8ProfilerMarker(value);
has_marker_ = true;
}

bool hasStackId() const {
  return has_stack_id_;
}
uint64_t stackId() const {
  DCHECK(hasStackId());
return member_stack_id_;
}
uint64_t getStackIdOr(uint64_t fallback_value) const {
  if (!hasStackId()) {
  return fallback_value;
}
return member_stack_id_;
}
void setStackId(uint64_t value) {
  member_stack_id_ = value;
has_stack_id_ = true;
}

bool hasTimestamp() const {
  return true;
}
double timestamp() const {
  return member_timestamp_;
}
void setTimestamp(double value) {
  member_timestamp_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_marker_ = false;
bool has_stack_id_ = false;

V8ProfilerMarker member_marker_{static_cast<V8ProfilerMarker::Enum>(0)};
uint64_t member_stack_id_;
double member_timestamp_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_SAMPLE_H_
