// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POINTER_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POINTER_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_mouse_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class PointerEvent;

class CORE_EXPORT PointerEventInit : public MouseEventInit {
  
  public:
static PointerEventInit* Create() {
  return MakeGarbageCollected<PointerEventInit>();
}
static PointerEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PointerEventInit>(isolate);
}
static PointerEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PointerEventInit();
explicit  PointerEventInit(v8::Isolate* isolate);

bool hasAltitudeAngle() const {
  return has_altitude_angle_;
}
double altitudeAngle() const {
  DCHECK(hasAltitudeAngle());
return member_altitude_angle_;
}
double getAltitudeAngleOr(double fallback_value) const {
  if (!hasAltitudeAngle()) {
  return fallback_value;
}
return member_altitude_angle_;
}
void setAltitudeAngle(double value) {
  member_altitude_angle_ = value;
has_altitude_angle_ = true;
}

bool hasAzimuthAngle() const {
  return has_azimuth_angle_;
}
double azimuthAngle() const {
  DCHECK(hasAzimuthAngle());
return member_azimuth_angle_;
}
double getAzimuthAngleOr(double fallback_value) const {
  if (!hasAzimuthAngle()) {
  return fallback_value;
}
return member_azimuth_angle_;
}
void setAzimuthAngle(double value) {
  member_azimuth_angle_ = value;
has_azimuth_angle_ = true;
}

bool hasCoalescedEvents() const {
  return true;
}
const HeapVector<Member<PointerEvent>>& coalescedEvents() const {
  return member_coalesced_events_;
}
void setCoalescedEvents(const HeapVector<Member<PointerEvent>>& value);
void setCoalescedEvents(HeapVector<Member<PointerEvent>>&& value);

bool hasHeight() const {
  return true;
}
double height() const {
  return member_height_;
}
void setHeight(double value) {
  member_height_ = value;
}

bool hasIsPrimary() const {
  return true;
}
bool isPrimary() const {
  return member_is_primary_;
}
void setIsPrimary(bool value) {
  member_is_primary_ = value;
}

bool hasPersistentDeviceId() const {
  return true;
}
int32_t persistentDeviceId() const {
  return member_persistent_device_id_;
}
void setPersistentDeviceId(int32_t value) {
  member_persistent_device_id_ = value;
}

bool hasPointerId() const {
  return true;
}
int32_t pointerId() const {
  return member_pointer_id_;
}
void setPointerId(int32_t value) {
  member_pointer_id_ = value;
}

bool hasPointerType() const {
  return true;
}
const String& pointerType() const {
  return member_pointer_type_;
}
void setPointerType(const String& value);
void setPointerType(String&& value);

bool hasPredictedEvents() const {
  return true;
}
const HeapVector<Member<PointerEvent>>& predictedEvents() const {
  return member_predicted_events_;
}
void setPredictedEvents(const HeapVector<Member<PointerEvent>>& value);
void setPredictedEvents(HeapVector<Member<PointerEvent>>&& value);

bool hasPressure() const {
  return true;
}
float pressure() const {
  return member_pressure_;
}
void setPressure(float value) {
  member_pressure_ = value;
}

bool hasTangentialPressure() const {
  return true;
}
float tangentialPressure() const {
  return member_tangential_pressure_;
}
void setTangentialPressure(float value) {
  member_tangential_pressure_ = value;
}

bool hasTiltX() const {
  return has_tilt_x_;
}
int32_t tiltX() const {
  DCHECK(hasTiltX());
return member_tilt_x_;
}
int32_t getTiltXOr(int32_t fallback_value) const {
  if (!hasTiltX()) {
  return fallback_value;
}
return member_tilt_x_;
}
void setTiltX(int32_t value) {
  member_tilt_x_ = value;
has_tilt_x_ = true;
}

bool hasTiltY() const {
  return has_tilt_y_;
}
int32_t tiltY() const {
  DCHECK(hasTiltY());
return member_tilt_y_;
}
int32_t getTiltYOr(int32_t fallback_value) const {
  if (!hasTiltY()) {
  return fallback_value;
}
return member_tilt_y_;
}
void setTiltY(int32_t value) {
  member_tilt_y_ = value;
has_tilt_y_ = true;
}

bool hasTwist() const {
  return true;
}
int32_t twist() const {
  return member_twist_;
}
void setTwist(int32_t value) {
  member_twist_ = value;
}

bool hasWidth() const {
  return true;
}
double width() const {
  return member_width_;
}
void setWidth(double value) {
  member_width_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = MouseEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 15;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_altitude_angle_ = false;
bool has_azimuth_angle_ = false;
bool has_tilt_x_ = false;
bool has_tilt_y_ = false;

double member_altitude_angle_;
double member_azimuth_angle_;
HeapVector<Member<PointerEvent>> member_coalesced_events_;
double member_height_{1};
bool member_is_primary_{false};
int32_t member_persistent_device_id_{0};
int32_t member_pointer_id_{0};
String member_pointer_type_{""};
HeapVector<Member<PointerEvent>> member_predicted_events_;
float member_pressure_{0};
float member_tangential_pressure_{0};
int32_t member_tilt_x_;
int32_t member_tilt_y_;
int32_t member_twist_{0};
double member_width_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POINTER_EVENT_INIT_H_
