// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_pointer_event_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/events/pointer_event.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"altitudeAngle",
"azimuthAngle",
"coalescedEvents",
"height",
"isPrimary",
"persistentDeviceId",
"pointerId",
"pointerType",
"predictedEvents",
"pressure",
"tangentialPressure",
"tiltX",
"tiltY",
"twist",
"width",
};


}  // namespace 

PointerEventInit* PointerEventInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PointerEventInit* dictionary = MakeGarbageCollected<PointerEventInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PointerEventInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PointerEventInit::PointerEventInit() {
  
}

 PointerEventInit::PointerEventInit(v8::Isolate* isolate) : MouseEventInit(isolate) {
  
}

















void PointerEventInit::setCoalescedEvents(const HeapVector<Member<PointerEvent>>& value) {
  member_coalesced_events_ = value;
}

void PointerEventInit::setCoalescedEvents(HeapVector<Member<PointerEvent>>&& value) {
  member_coalesced_events_ = std::move(value);
}
























void PointerEventInit::setPointerType(const String& value) {
  member_pointer_type_ = value;
}

void PointerEventInit::setPointerType(String&& value) {
  member_pointer_type_ = std::move(value);
}




void PointerEventInit::setPredictedEvents(const HeapVector<Member<PointerEvent>>& value) {
  member_predicted_events_ = value;
}

void PointerEventInit::setPredictedEvents(HeapVector<Member<PointerEvent>>&& value) {
  member_predicted_events_ = std::move(value);
}






































void PointerEventInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_coalesced_events_);
visitor->Trace(member_predicted_events_);
MouseEventInit::Trace(visitor);
}

void PointerEventInit::FillTemplateProperties(Vector<std::string_view>& properties) const {
  MouseEventInit::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PointerEventInit::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  MouseEventInit::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAltitudeAngle()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_altitude_angle_);
DCHECK(!values[0].IsEmpty());
}
if (hasAzimuthAngle()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_azimuth_angle_);
DCHECK(!values[1].IsEmpty());
}
if (hasCoalescedEvents()) {
  values[2] = ToV8Traits<IDLSequence<PointerEvent>>::ToV8(script_state, member_coalesced_events_);
DCHECK(!values[2].IsEmpty());
}
if (hasHeight()) {
  values[3] = ToV8Traits<IDLDouble>::ToV8(script_state, member_height_);
DCHECK(!values[3].IsEmpty());
}
if (hasIsPrimary()) {
  values[4] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_is_primary_);
DCHECK(!values[4].IsEmpty());
}
if (hasPersistentDeviceId()) {
  values[5] = ToV8Traits<IDLLong>::ToV8(script_state, member_persistent_device_id_);
DCHECK(!values[5].IsEmpty());
}
if (hasPointerId()) {
  values[6] = ToV8Traits<IDLLong>::ToV8(script_state, member_pointer_id_);
DCHECK(!values[6].IsEmpty());
}
if (hasPointerType()) {
  values[7] = ToV8Traits<IDLString>::ToV8(script_state, member_pointer_type_);
DCHECK(!values[7].IsEmpty());
}
if (hasPredictedEvents()) {
  values[8] = ToV8Traits<IDLSequence<PointerEvent>>::ToV8(script_state, member_predicted_events_);
DCHECK(!values[8].IsEmpty());
}
if (hasPressure()) {
  values[9] = ToV8Traits<IDLFloat>::ToV8(script_state, member_pressure_);
DCHECK(!values[9].IsEmpty());
}
if (hasTangentialPressure()) {
  values[10] = ToV8Traits<IDLFloat>::ToV8(script_state, member_tangential_pressure_);
DCHECK(!values[10].IsEmpty());
}
if (hasTiltX()) {
  values[11] = ToV8Traits<IDLLong>::ToV8(script_state, member_tilt_x_);
DCHECK(!values[11].IsEmpty());
}
if (hasTiltY()) {
  values[12] = ToV8Traits<IDLLong>::ToV8(script_state, member_tilt_y_);
DCHECK(!values[12].IsEmpty());
}
if (hasTwist()) {
  values[13] = ToV8Traits<IDLLong>::ToV8(script_state, member_twist_);
DCHECK(!values[13].IsEmpty());
}
if (hasWidth()) {
  values[14] = ToV8Traits<IDLDouble>::ToV8(script_state, member_width_);
DCHECK(!values[14].IsEmpty());
}
}

const void* PointerEventInit::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PointerEventInit::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PointerEventInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
MouseEventInit::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "PointerEventInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("altitudeAngle");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_altitude_angle_, member_altitude_angle_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("azimuthAngle");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_azimuth_angle_, member_azimuth_angle_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("coalescedEvents");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PointerEvent>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_coalesced_events_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("height");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("isPrimary");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_is_primary_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("persistentDeviceId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_persistent_device_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pointerId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_pointer_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pointerType");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_pointer_type_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("predictedEvents");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PointerEvent>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_predicted_events_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pressure");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_pressure_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tangentialPressure");
if (!bindings::GetDictionaryMemberFromV8Object<IDLFloat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_tangential_pressure_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tiltX");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_tilt_x_, member_tilt_x_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("tiltY");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_tilt_y_, member_tilt_y_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("twist");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), fallback_presence_var, member_twist_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("width");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), fallback_presence_var, member_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PointerEventInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
