// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PerformanceObserverInit : public bindings::InputDictionaryBase {
  
  public:
static PerformanceObserverInit* Create() {
  return MakeGarbageCollected<PerformanceObserverInit>();
}
static PerformanceObserverInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PerformanceObserverInit>(isolate);
}
static PerformanceObserverInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PerformanceObserverInit();
explicit  PerformanceObserverInit(v8::Isolate* isolate);

bool hasBuffered() const {
  return true;
}
bool buffered() const {
  return member_buffered_;
}
void setBuffered(bool value) {
  member_buffered_ = value;
}

bool hasDurationThreshold() const {
  return has_duration_threshold_;
}
double durationThreshold() const {
  DCHECK(hasDurationThreshold());
return member_duration_threshold_;
}
double getDurationThresholdOr(double fallback_value) const {
  if (!hasDurationThreshold()) {
  return fallback_value;
}
return member_duration_threshold_;
}
void setDurationThreshold(double value) {
  member_duration_threshold_ = value;
has_duration_threshold_ = true;
}

bool hasEntryTypes() const {
  return has_entry_types_;
}
const Vector<String>& entryTypes() const {
  DCHECK(hasEntryTypes());
return member_entry_types_;
}
Vector<String> getEntryTypesOr(const Vector<String>& fallback_value) const;
Vector<String> getEntryTypesOr(Vector<String>&& fallback_value) const;
void setEntryTypes(const Vector<String>& value);
void setEntryTypes(Vector<String>&& value);

bool hasType() const {
  return has_type_;
}
const String& type() const {
  DCHECK(hasType());
return member_type_;
}
String getTypeOr(const String& fallback_value) const;
String getTypeOr(String&& fallback_value) const;
void setType(const String& value);
void setType(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_duration_threshold_ = false;
bool has_entry_types_ = false;
bool has_type_ = false;

bool member_buffered_{false};
double member_duration_threshold_;
Vector<String> member_entry_types_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_INIT_H_
