// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MARK_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MARK_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PerformanceMarkOptions : public bindings::InputDictionaryBase {
  
  public:
static PerformanceMarkOptions* Create() {
  return MakeGarbageCollected<PerformanceMarkOptions>();
}
static PerformanceMarkOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PerformanceMarkOptions>(isolate);
}
static PerformanceMarkOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PerformanceMarkOptions();
explicit  PerformanceMarkOptions(v8::Isolate* isolate);

bool hasDetail() const {
  return !member_detail_.IsEmpty();
}
const ScriptValue& detail() const {
  DCHECK(hasDetail());
return member_detail_;
}
ScriptValue getDetailOr(const ScriptValue& fallback_value) const {
  if (!hasDetail()) {
  return fallback_value;
}
return member_detail_;
}
void setDetail(const ScriptValue& value) {
  member_detail_ = value;
}

bool hasStartTime() const {
  return has_start_time_;
}
double startTime() const {
  DCHECK(hasStartTime());
return member_start_time_;
}
double getStartTimeOr(double fallback_value) const {
  if (!hasStartTime()) {
  return fallback_value;
}
return member_start_time_;
}
void setStartTime(double value) {
  member_start_time_ = value;
has_start_time_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_start_time_ = false;

ScriptValue member_detail_;
double member_start_time_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MARK_OPTIONS_H_
