// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_performance.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_counts.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_handler_non_null.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_target.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_function.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_memory_info.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_memory_measurement.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_entry.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_mark.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_mark_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_measure.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_measure_options.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_navigation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_performance_timing.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_performancemeasureoptions_string.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/timing/event_counts.h"
#include "third_party/blink/renderer/core/timing/memory_info.h"
#include "third_party/blink/renderer/core/timing/performance.h"
#include "third_party/blink/renderer/core/timing/performance_entry.h"
#include "third_party/blink/renderer/core/timing/performance_mark.h"
#include "third_party/blink/renderer/core/timing/performance_measure.h"
#include "third_party/blink/renderer/core/timing/performance_navigation.h"
#include "third_party/blink/renderer/core/timing/performance_timing.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8Performance::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() || execution_context->IsWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8Performance::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8Performance::InstallInterfaceTemplate,
    V8Performance::InstallContextDependentProperties,
    "Performance",
    V8EventTarget::GetWrapperTypeInfo(),
    V8Performance::kThisTag,
    V8Performance::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& Performance::wrapper_type_info_ =
    V8Performance::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, Performance>::value,
    "Performance inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_performance {


void TimeOriginAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_timeOrigin_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.timeOrigin.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->timeOrigin();
static_assert(bindings::IsReturnTypeCompatible<IDLDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}



void OnresourcetimingbufferfullAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_onresourcetimingbufferfull_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.onresourcetimingbufferfull.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->onresourcetimingbufferfull();
static_assert(bindings::IsReturnTypeCompatible<IDLEventHandler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, blink_receiver);
}

void OnresourcetimingbufferfullAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_onresourcetimingbufferfull_Setter");
BLINK_BINDINGS_TRACE_EVENT("Performance.onresourcetimingbufferfull.set");

v8::Local<v8::Value> v8_property_value = info[0];
EventListener* event_handler = JSEventHandler::CreateOrNull(
    v8_property_value,
    JSEventHandler::HandlerType::kEventHandler);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->setOnresourcetimingbufferfull(event_handler);
}


void TimingAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_timing_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.timing.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Performance_Timing_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->timing();
static_assert(bindings::IsReturnTypeCompatible<PerformanceTiming, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void NavigationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_navigation_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.navigation.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Performance_Navigation_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->navigation();
static_assert(bindings::IsReturnTypeCompatible<PerformanceNavigation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void MemoryAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_memory_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.memory.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8Performance_Memory_AttributeGetter);



v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->memory(script_state);
static_assert(bindings::IsReturnTypeCompatible<MemoryInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void EventCountsAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_eventCounts_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.eventCounts.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
// [SaveSameObject]
static const V8PrivateProperty::SymbolKey kPrivatePropertySaveSameObject;
auto&& v8_private_save_same_object =
    V8PrivateProperty::GetSymbol(isolate, kPrivatePropertySaveSameObject);
{
  v8::Local<v8::Value> v8_value;
  if (!v8_private_save_same_object.GetOrUndefined(v8_receiver)
           .ToLocal(&v8_value)) {
    return;
  }
  if (!v8_value->IsUndefined()) {
    bindings::V8SetReturnValue(info, v8_value);
    return;
  }
}

Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->eventCounts();
static_assert(bindings::IsReturnTypeCompatible<EventCounts, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
// [SaveSameObject]
v8_private_save_same_object.Set(v8_receiver, info.GetReturnValue().Get());
}



void InteractionCountAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_interactionCount_Getter");
BLINK_BINDINGS_TRACE_EVENT("Performance.interactionCount.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->interactionCount();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLongLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint64_t>());
}


void BindOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_bind");
BLINK_BINDINGS_TRACE_EVENT("Performance.bind");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
V8Function* return_value;
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_inner_function = NativeValueTraits<V8Function>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
if (non_undefined_argument_length <= 1) {
  return_value = blink_receiver->bind(arg1_inner_function);
break;
}
auto&& arg2_this_arg = NativeValueTraits<IDLOptional<IDLAny>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_args = bindings::VariadicArgumentsToNativeValues<IDLAny>(isolate, info, 2, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = blink_receiver->bind(arg1_inner_function, arg2_this_arg, arg3_args);
} while (false);
v8::Local<v8::Value> v8_return_value = ToV8Traits<V8Function>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void ClearMarksOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_clearMarks");
BLINK_BINDINGS_TRACE_EVENT("Performance.clearMarks");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kUserTiming);




do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  blink_receiver->clearMarks();
break;
}
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_mark_name;
if (info[0]->IsString()) [[likely]] {
  arg1_mark_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_mark_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->clearMarks(arg1_mark_name);
} while (false);

}

void ClearMeasuresOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_clearMeasures");
BLINK_BINDINGS_TRACE_EVENT("Performance.clearMeasures");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kUserTiming);




do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
if (non_undefined_argument_length <= 0) {
  blink_receiver->clearMeasures();
break;
}
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_measure_name;
if (info[0]->IsString()) [[likely]] {
  arg1_measure_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_measure_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->clearMeasures(arg1_measure_name);
} while (false);

}

void ClearResourceTimingsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_clearResourceTimings");
BLINK_BINDINGS_TRACE_EVENT("Performance.clearResourceTimings");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->clearResourceTimings();

}

void GetEntriesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_getEntries");
BLINK_BINDINGS_TRACE_EVENT("Performance.getEntries");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPerformanceTimeline);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getEntries();
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<PerformanceEntry>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<PerformanceEntry>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetEntriesByNameOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_getEntriesByName");
BLINK_BINDINGS_TRACE_EVENT("Performance.getEntriesByName");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPerformanceTimeline);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
HeapVector<Member<PerformanceEntry>> return_value;
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_name;
if (info[0]->IsString()) [[likely]] {
  arg1_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 1) {
  return_value = blink_receiver->getEntriesByName(arg1_name);
break;
}
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_entry_type;
if (info[1]->IsString()) [[likely]] {
  arg2_entry_type.Init(isolate, info[1].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg2_entry_type = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
return_value = blink_receiver->getEntriesByName(arg1_name, arg2_entry_type);
} while (false);
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<PerformanceEntry>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetEntriesByTypeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_getEntriesByType");
BLINK_BINDINGS_TRACE_EVENT("Performance.getEntriesByType");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kPerformanceTimeline);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_entry_type;
if (info[0]->IsString()) [[likely]] {
  arg1_entry_type.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_entry_type = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->getEntriesByType(arg1_entry_type);
static_assert(bindings::IsReturnTypeCompatible<IDLSequence<PerformanceEntry>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLSequence<PerformanceEntry>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void MarkOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_mark");
BLINK_BINDINGS_TRACE_EVENT("Performance.mark");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kUserTiming);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_mark_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<PerformanceMarkOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_mark_options;
if (info[1]->IsUndefined()) {
  arg2_mark_options = PerformanceMarkOptions::Create();
} else {
  arg2_mark_options = NativeValueTraits<PerformanceMarkOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->mark(script_state, arg1_mark_name, arg2_mark_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<PerformanceMark, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void MeasureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_measure");
BLINK_BINDINGS_TRACE_EVENT("Performance.measure");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kUserTiming);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


PerformanceMeasure* return_value;
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
do {  // Dummy loop for use of 'break'.
  const int non_undefined_argument_length = bindings::NonUndefinedArgumentLength(info);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& arg1_measure_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<V8UnionPerformanceMeasureOptionsOrString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_start_or_measure_options;
if (info[1]->IsUndefined()) {
  arg2_start_or_measure_options = MakeGarbageCollected<V8UnionPerformanceMeasureOptionsOrString>(PerformanceMeasureOptions::Create());
} else {
  arg2_start_or_measure_options = NativeValueTraits<V8UnionPerformanceMeasureOptionsOrString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
if (non_undefined_argument_length <= 2) {
  return_value = blink_receiver->measure(script_state, arg1_measure_name, arg2_start_or_measure_options, exception_state);
break;
}
auto&& arg3_end_mark = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
return_value = blink_receiver->measure(script_state, arg1_measure_name, arg2_start_or_measure_options, arg3_end_mark, exception_state);
} while (false);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void MeasureUserAgentSpecificMemoryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_measureUserAgentSpecificMemory");
BLINK_BINDINGS_TRACE_EVENT("Performance.measureUserAgentSpecificMemory");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8Performance::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kMeasureMemory);




Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "Performance";
const char* const property_name = "measureUserAgentSpecificMemory";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->measureUserAgentSpecificMemory(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<MemoryMeasurement>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

double NowOperationNoAllocDirectCallArg0(v8::Local<v8::Object> v8_arg0_receiver, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->now();
return return_value;
}

void NowOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_now");
BLINK_BINDINGS_TRACE_EVENT("Performance.now");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->now();
static_assert(bindings::IsReturnTypeCompatible<IDLDouble, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<double>());
}

void SetResourceTimingBufferSizeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_setResourceTimingBufferSize");
BLINK_BINDINGS_TRACE_EVENT("Performance.setResourceTimingBufferSize");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_max_size = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setResourceTimingBufferSize(arg1_max_size);

}

void ToJSONOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Performance_toJSON");
BLINK_BINDINGS_TRACE_EVENT("Performance.toJSON");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
Performance* blink_receiver = V8Performance::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->toJSONForBinding(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLObject, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}


}  // namespace v8_performance

using namespace v8_performance;

}  // namespace 

void V8Performance::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8Performance::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8Performance::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"timeOrigin", TimeOriginAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"onresourcetimingbufferfull", OnresourcetimingbufferfullAttributeGetCallback, OnresourcetimingbufferfullAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Performance", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clearMarks", ClearMarksOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"clearMeasures", ClearMeasuresOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"clearResourceTimings", ClearResourceTimingsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getEntries", GetEntriesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getEntriesByName", GetEntriesByNameOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getEntriesByType", GetEntriesByTypeOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"mark", MarkOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"measure", MeasureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setResourceTimingBufferSize", SetResourceTimingBufferSizeOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"toJSON", ToJSONOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Performance", kOperationTable);
}


{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfNow[] = {
v8::CFunctionBuilder().Fn(NowOperationNoAllocDirectCallArg0).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"now", NowOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect)}, kNoAllocDirectCallOverloadsOfNow, std::size(kNoAllocDirectCallOverloadsOfNow)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Performance", kOperationTable);
}


}


void V8Performance::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (execution_context->IsWindow() && feature_selector.IsAll()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"timing", TimingAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"navigation", NavigationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"memory", MemoryAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"eventCounts", EventCountsAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Performance", kAttributeTable);
}
if (execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::EventTimingInteractionCountEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"interactionCount", InteractionCountAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "Performance", kAttributeTable);
}




if (execution_context->IsWindow() && (feature_selector.IsAll() && RuntimeEnabledFeatures::UserDefinedEntryPointTimingEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"bind", BindOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Performance", kOperationTable);
}
const bool is_cross_origin_isolated = execution_context->CrossOriginIsolatedCapabilityOrDisabledWebSecurity();
if ((is_cross_origin_isolated || RuntimeEnabledFeatures::UnrestrictedMeasureUserAgentSpecificMemoryEnabled()) && (execution_context->IsWindow() || execution_context->IsServiceWorkerGlobalScope() || execution_context->IsSharedWorkerGlobalScope()) && (feature_selector.IsAll() && RuntimeEnabledFeatures::MeasureMemoryEnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"measureUserAgentSpecificMemory", MeasureUserAgentSpecificMemoryOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "Performance", kOperationTable);
}


}


}  // namespace blink
