// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_observable_inspector.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observable_inspector_abort_handler.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observer_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_observer_complete_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_void_function.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"abort",
"complete",
"error",
"next",
"subscribe",
};


}  // namespace 

ObservableInspector* ObservableInspector::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ObservableInspector* dictionary = MakeGarbageCollected<ObservableInspector>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ObservableInspector";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ObservableInspector::ObservableInspector() {
  
}

 ObservableInspector::ObservableInspector(v8::Isolate* isolate) {
  
}






































void ObservableInspector::Trace(Visitor* visitor) const {
  visitor->Trace(member_abort_);
visitor->Trace(member_complete_);
visitor->Trace(member_error_);
visitor->Trace(member_next_);
visitor->Trace(member_subscribe_);
bindings::InputDictionaryBase::Trace(visitor);
}

void ObservableInspector::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ObservableInspector";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("abort");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8ObservableInspectorAbortHandler, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_abort_, member_abort_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("complete");
if (!bindings::GetDictionaryMemberFromV8Object<V8ObserverCompleteCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_complete_, member_complete_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("error");
if (!bindings::GetDictionaryMemberFromV8Object<V8ObserverCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_error_, member_error_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("next");
if (!bindings::GetDictionaryMemberFromV8Object<V8ObserverCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_next_, member_next_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("subscribe");
if (!bindings::GetDictionaryMemberFromV8Object<V8VoidFunction, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_subscribe_, member_subscribe_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ObservableInspector::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
