// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT NavigationOptions : public bindings::InputDictionaryBase {
  
  public:
static NavigationOptions* Create() {
  return MakeGarbageCollected<NavigationOptions>();
}
static NavigationOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<NavigationOptions>(isolate);
}
static NavigationOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  NavigationOptions();
explicit  NavigationOptions(v8::Isolate* isolate);

bool hasInfo() const {
  return !member_info_.IsEmpty();
}
const ScriptValue& info() const {
  DCHECK(hasInfo());
return member_info_;
}
ScriptValue getInfoOr(const ScriptValue& fallback_value) const {
  if (!hasInfo()) {
  return fallback_value;
}
return member_info_;
}
void setInfo(const ScriptValue& value) {
  member_info_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



ScriptValue member_info_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NAVIGATION_OPTIONS_H_
