// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MUTATION_OBSERVER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MUTATION_OBSERVER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT MutationObserverInit : public bindings::InputDictionaryBase {
  
  public:
static MutationObserverInit* Create() {
  return MakeGarbageCollected<MutationObserverInit>();
}
static MutationObserverInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MutationObserverInit>(isolate);
}
static MutationObserverInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MutationObserverInit();
explicit  MutationObserverInit(v8::Isolate* isolate);

bool hasAttributeFilter() const {
  return has_attribute_filter_;
}
const Vector<String>& attributeFilter() const {
  DCHECK(hasAttributeFilter());
return member_attribute_filter_;
}
Vector<String> getAttributeFilterOr(const Vector<String>& fallback_value) const;
Vector<String> getAttributeFilterOr(Vector<String>&& fallback_value) const;
void setAttributeFilter(const Vector<String>& value);
void setAttributeFilter(Vector<String>&& value);

bool hasAttributeOldValue() const {
  return has_attribute_old_value_;
}
bool attributeOldValue() const {
  DCHECK(hasAttributeOldValue());
return member_attribute_old_value_;
}
bool getAttributeOldValueOr(bool fallback_value) const {
  if (!hasAttributeOldValue()) {
  return fallback_value;
}
return member_attribute_old_value_;
}
void setAttributeOldValue(bool value) {
  member_attribute_old_value_ = value;
has_attribute_old_value_ = true;
}

bool hasAttributes() const {
  return has_attributes_;
}
bool attributes() const {
  DCHECK(hasAttributes());
return member_attributes_;
}
bool getAttributesOr(bool fallback_value) const {
  if (!hasAttributes()) {
  return fallback_value;
}
return member_attributes_;
}
void setAttributes(bool value) {
  member_attributes_ = value;
has_attributes_ = true;
}

bool hasCharacterData() const {
  return has_character_data_;
}
bool characterData() const {
  DCHECK(hasCharacterData());
return member_character_data_;
}
bool getCharacterDataOr(bool fallback_value) const {
  if (!hasCharacterData()) {
  return fallback_value;
}
return member_character_data_;
}
void setCharacterData(bool value) {
  member_character_data_ = value;
has_character_data_ = true;
}

bool hasCharacterDataOldValue() const {
  return has_character_data_old_value_;
}
bool characterDataOldValue() const {
  DCHECK(hasCharacterDataOldValue());
return member_character_data_old_value_;
}
bool getCharacterDataOldValueOr(bool fallback_value) const {
  if (!hasCharacterDataOldValue()) {
  return fallback_value;
}
return member_character_data_old_value_;
}
void setCharacterDataOldValue(bool value) {
  member_character_data_old_value_ = value;
has_character_data_old_value_ = true;
}

bool hasChildList() const {
  return true;
}
bool childList() const {
  return member_child_list_;
}
void setChildList(bool value) {
  member_child_list_ = value;
}

bool hasSubtree() const {
  return true;
}
bool subtree() const {
  return member_subtree_;
}
void setSubtree(bool value) {
  member_subtree_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_attribute_filter_ = false;
bool has_attribute_old_value_ = false;
bool has_attributes_ = false;
bool has_character_data_ = false;
bool has_character_data_old_value_ = false;

Vector<String> member_attribute_filter_;
bool member_attribute_old_value_;
bool member_attributes_;
bool member_character_data_;
bool member_character_data_old_value_;
bool member_child_list_{false};
bool member_subtree_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MUTATION_OBSERVER_INIT_H_
