// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_READ_MESSAGE_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_READ_MESSAGE_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MojoHandle;

class CORE_EXPORT MojoReadMessageResult : public bindings::DictionaryBase {
  
  public:
static MojoReadMessageResult* Create() {
  return MakeGarbageCollected<MojoReadMessageResult>();
}
static MojoReadMessageResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoReadMessageResult>(isolate);
}
static MojoReadMessageResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoReadMessageResult();
explicit  MojoReadMessageResult(v8::Isolate* isolate);

bool hasBuffer() const {
  return has_buffer_;
}
DOMArrayBuffer* buffer() const {
  DCHECK(hasBuffer());
return member_buffer_.Get();
}
DOMArrayBuffer* getBufferOr(DOMArrayBuffer* fallback_value) const {
  if (!hasBuffer()) {
  return fallback_value;
}
return member_buffer_.Get();
}
void setBuffer(DOMArrayBuffer* value) {
  member_buffer_ = value;
has_buffer_ = true;
DCHECK(member_buffer_);
}

bool hasHandles() const {
  return has_handles_;
}
const HeapVector<Member<MojoHandle>>& handles() const {
  DCHECK(hasHandles());
return member_handles_;
}
HeapVector<Member<MojoHandle>> getHandlesOr(const HeapVector<Member<MojoHandle>>& fallback_value) const;
HeapVector<Member<MojoHandle>> getHandlesOr(HeapVector<Member<MojoHandle>>&& fallback_value) const;
void setHandles(const HeapVector<Member<MojoHandle>>& value);
void setHandles(HeapVector<Member<MojoHandle>>&& value);

bool hasResult() const {
  return true;
}
uint32_t result() const {
  return member_result_;
}
void setResult(uint32_t value) {
  member_result_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_buffer_ = false;
bool has_handles_ = false;

Member<DOMArrayBuffer> member_buffer_;
HeapVector<Member<MojoHandle>> member_handles_;
uint32_t member_result_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_READ_MESSAGE_RESULT_H_
