// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_MESSAGE_PIPE_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_MESSAGE_PIPE_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MojoHandle;

class CORE_EXPORT MojoCreateMessagePipeResult : public bindings::DictionaryBase {
  
  public:
static MojoCreateMessagePipeResult* Create() {
  return MakeGarbageCollected<MojoCreateMessagePipeResult>();
}
static MojoCreateMessagePipeResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoCreateMessagePipeResult>(isolate);
}
static MojoCreateMessagePipeResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoCreateMessagePipeResult();
explicit  MojoCreateMessagePipeResult(v8::Isolate* isolate);

bool hasHandle0() const {
  return has_handle_0_;
}
MojoHandle* handle0() const {
  DCHECK(hasHandle0());
return member_handle_0_.Get();
}
MojoHandle* getHandle0Or(MojoHandle* fallback_value) const {
  if (!hasHandle0()) {
  return fallback_value;
}
return member_handle_0_.Get();
}
void setHandle0(MojoHandle* value) {
  member_handle_0_ = value;
has_handle_0_ = true;
DCHECK(member_handle_0_);
}

bool hasHandle1() const {
  return has_handle_1_;
}
MojoHandle* handle1() const {
  DCHECK(hasHandle1());
return member_handle_1_.Get();
}
MojoHandle* getHandle1Or(MojoHandle* fallback_value) const {
  if (!hasHandle1()) {
  return fallback_value;
}
return member_handle_1_.Get();
}
void setHandle1(MojoHandle* value) {
  member_handle_1_ = value;
has_handle_1_ = true;
DCHECK(member_handle_1_);
}

bool hasResult() const {
  return true;
}
uint32_t result() const {
  return member_result_;
}
void setResult(uint32_t value) {
  member_result_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_handle_0_ = false;
bool has_handle_1_ = false;

Member<MojoHandle> member_handle_0_;
Member<MojoHandle> member_handle_1_;
uint32_t member_result_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_MESSAGE_PIPE_RESULT_H_
