// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MojoHandle;

class CORE_EXPORT MojoCreateDataPipeResult : public bindings::DictionaryBase {
  
  public:
static MojoCreateDataPipeResult* Create() {
  return MakeGarbageCollected<MojoCreateDataPipeResult>();
}
static MojoCreateDataPipeResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MojoCreateDataPipeResult>(isolate);
}
static MojoCreateDataPipeResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MojoCreateDataPipeResult();
explicit  MojoCreateDataPipeResult(v8::Isolate* isolate);

bool hasConsumer() const {
  return has_consumer_;
}
MojoHandle* consumer() const {
  DCHECK(hasConsumer());
return member_consumer_.Get();
}
MojoHandle* getConsumerOr(MojoHandle* fallback_value) const {
  if (!hasConsumer()) {
  return fallback_value;
}
return member_consumer_.Get();
}
void setConsumer(MojoHandle* value) {
  member_consumer_ = value;
has_consumer_ = true;
DCHECK(member_consumer_);
}

bool hasProducer() const {
  return has_producer_;
}
MojoHandle* producer() const {
  DCHECK(hasProducer());
return member_producer_.Get();
}
MojoHandle* getProducerOr(MojoHandle* fallback_value) const {
  if (!hasProducer()) {
  return fallback_value;
}
return member_producer_.Get();
}
void setProducer(MojoHandle* value) {
  member_producer_ = value;
has_producer_ = true;
DCHECK(member_producer_);
}

bool hasResult() const {
  return true;
}
uint32_t result() const {
  return member_result_;
}
void setResult(uint32_t value) {
  member_result_ = value;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_consumer_ = false;
bool has_producer_ = false;

Member<MojoHandle> member_consumer_;
Member<MojoHandle> member_producer_;
uint32_t member_result_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MOJO_CREATE_DATA_PIPE_RESULT_H_
