// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_memory_attribution_container.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"id",
"src",
};


}  // namespace 

MemoryAttributionContainer* MemoryAttributionContainer::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  MemoryAttributionContainer* dictionary = MakeGarbageCollected<MemoryAttributionContainer>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "MemoryAttributionContainer";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 MemoryAttributionContainer::MemoryAttributionContainer() {
  
}

 MemoryAttributionContainer::MemoryAttributionContainer(v8::Isolate* isolate) {
  
}



String MemoryAttributionContainer::getIdOr(const String& fallback_value) const {
  if (!hasId()) {
  return fallback_value;
}
return member_id_;
}

String MemoryAttributionContainer::getIdOr(String&& fallback_value) const {
  if (!hasId()) {
  return std::move(fallback_value);
}
return member_id_;
}

void MemoryAttributionContainer::setId(const String& value) {
  member_id_ = value;
has_id_ = true;
}

void MemoryAttributionContainer::setId(String&& value) {
  member_id_ = std::move(value);
has_id_ = true;
}




String MemoryAttributionContainer::getSrcOr(const String& fallback_value) const {
  if (!hasSrc()) {
  return fallback_value;
}
return member_src_;
}

String MemoryAttributionContainer::getSrcOr(String&& fallback_value) const {
  if (!hasSrc()) {
  return std::move(fallback_value);
}
return member_src_;
}

void MemoryAttributionContainer::setSrc(const String& value) {
  member_src_ = value;
has_src_ = true;
}

void MemoryAttributionContainer::setSrc(String&& value) {
  member_src_ = std::move(value);
has_src_ = true;
}




void MemoryAttributionContainer::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void MemoryAttributionContainer::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void MemoryAttributionContainer::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasId()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_id_);
DCHECK(!values[0].IsEmpty());
}
if (hasSrc()) {
  values[1] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_src_);
DCHECK(!values[1].IsEmpty());
}
}

const void* MemoryAttributionContainer::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> MemoryAttributionContainer::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void MemoryAttributionContainer::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "MemoryAttributionContainer";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("id");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_id_, member_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("src");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_src_, member_src_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> MemoryAttributionContainer::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
