// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_ATTRIBUTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_ATTRIBUTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MemoryAttributionContainer;

class CORE_EXPORT MemoryAttribution : public bindings::DictionaryBase {
  
  public:
static MemoryAttribution* Create() {
  return MakeGarbageCollected<MemoryAttribution>();
}
static MemoryAttribution* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MemoryAttribution>(isolate);
}
static MemoryAttribution* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MemoryAttribution();
explicit  MemoryAttribution(v8::Isolate* isolate);

bool hasContainer() const {
  return has_container_;
}
MemoryAttributionContainer* container() const {
  DCHECK(hasContainer());
return member_container_.Get();
}
MemoryAttributionContainer* getContainerOr(MemoryAttributionContainer* fallback_value) const {
  if (!hasContainer()) {
  return fallback_value;
}
return member_container_.Get();
}
void setContainer(MemoryAttributionContainer* value) {
  member_container_ = value;
has_container_ = true;
DCHECK(member_container_);
}

bool hasScope() const {
  return true;
}
const String& scope() const {
  return member_scope_;
}
void setScope(const String& value);
void setScope(String&& value);

bool hasUrl() const {
  return true;
}
const String& url() const {
  return member_url_;
}
void setUrl(const String& value);
void setUrl(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_container_ = false;

Member<MemoryAttributionContainer> member_container_;
String member_scope_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_ATTRIBUTION_H_
