// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYFRAME_EFFECT_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYFRAME_EFFECT_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_composite_operation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_effect_timing.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT KeyframeEffectOptions : public EffectTiming {
  
  public:
static KeyframeEffectOptions* Create() {
  return MakeGarbageCollected<KeyframeEffectOptions>();
}
static KeyframeEffectOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<KeyframeEffectOptions>(isolate);
}
static KeyframeEffectOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  KeyframeEffectOptions();
explicit  KeyframeEffectOptions(v8::Isolate* isolate);

bool hasComposite() const {
  return true;
}
V8CompositeOperation composite() const {
  return member_composite_;
}
void setComposite(V8CompositeOperation value) {
  member_composite_ = value;
}
void setComposite(V8CompositeOperation::Enum value) {
  member_composite_ = V8CompositeOperation(value);
}

bool hasPseudoElement() const {
  return true;
}
const String& pseudoElement() const {
  return member_pseudo_element_;
}
void setPseudoElement(const String& value);
void setPseudoElement(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EffectTiming::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8CompositeOperation member_composite_{V8CompositeOperation::Enum::kReplace};
String member_pseudo_element_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_KEYFRAME_EFFECT_OPTIONS_H_
