// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_internals.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/testing/internals.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8Internals::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8Internals::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8Internals::InstallInterfaceTemplate,
    V8Internals::InstallContextDependentProperties,
    "Internals",
    nullptr,
    V8Internals::kThisTag,
    V8Internals::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& Internals::wrapper_type_info_ =
    V8Internals::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, Internals>::value,
    "Internals inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

// Cross-component trampolines
V8Internals::InstallInterfaceTemplateFuncType V8Internals::install_interface_template_func_ = nullptr;
V8Internals::InstallUnconditionalPropertiesFuncType V8Internals::install_unconditional_props_func_ = nullptr;
V8Internals::InstallContextDependentPropertiesFuncType V8Internals::install_context_dependent_props_func_ = nullptr;

v8::Intercepted V8Internals::IndexedPropertyGetterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertyGetter");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
// step 1.2. If index is a supported property index, then:
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
Internals* blink_receiver = V8Internals::ToWrappableUnsafe(isolate, v8_receiver);
if (index >= blink_receiver->length()) {
  // step 3. Return OrdinaryGetOwnProperty(O, P).
// Do not intercept.  Fallback to OrdinaryGetOwnProperty.
return v8::Intercepted::kNo;
}
auto&& return_value = blink_receiver->AnonymousIndexedGetter(index);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
return v8::Intercepted::kYes;
}

v8::Intercepted V8Internals::IndexedPropertySetterCallback(uint32_t index, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertySetter");

// 3.9.2. [[Set]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-set
// OrdinarySetWithOwnDescriptor will end up calling DefineOwnProperty,
// which will fail when the receiver object is this legacy platform
// object.
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Indexed property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8Internals::IndexedPropertyDeleterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertyDeleter");

// 3.9.4. [[Delete]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-delete
// step 1.2. If index is not a supported property index, then return true.
// step 1.3. Return false.
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
Internals* blink_receiver = V8Internals::ToWrappableUnsafe(isolate, v8_receiver);
const bool is_supported = index < blink_receiver->length();
bindings::V8SetReturnValue(info, !is_supported);
if (is_supported && info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Index property deleter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8Internals::IndexedPropertyDefinerCallback(uint32_t index, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertyDefiner");

// 3.9.3. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
// step 1.1. If the result of calling IsDataDescriptor(Desc) is false, then
//   return false.
if (v8_property_desc.has_get() || v8_property_desc.has_set()) {
  if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate,  "Accessor properties are not allowed.");
}
return v8::Intercepted::kYes;
}
// step 1.2. If O does not implement an interface with an indexed property
//   setter, then return false.
if (info.ShouldThrowOnError()) {
  v8::Isolate* isolate = info.GetIsolate();
V8ThrowException::ThrowTypeError(isolate, "Index property setter is not supported.");
}
return v8::Intercepted::kYes;
}

v8::Intercepted V8Internals::IndexedPropertyDescriptorCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertyDescriptor");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
// step 1.2. If index is a supported property index, then:
// step 1.2.3. If operation was defined without an identifier, then set
//   value to the result of performing the steps listed in the interface
//   description to determine the value of an indexed property with index
//   as the index.
// step 1.2.4. Otherwise, operation was defined with an identifier. Set
//   value to the result of performing the steps listed in the description
//   of operation with index as the only argument value.
auto intercepted =
    V8Internals::IndexedPropertyGetterCallback(index, info);
if (intercepted == v8::Intercepted::kNo) {
  // step 3. Return OrdinaryGetOwnProperty(O, P).
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}
// step 1.2.6. Set desc.[[Value]] to the result of converting value to an
//   ECMAScript value.
// step 1.2.7. If O implements an interface with an indexed property setter,
//   then set desc.[[Writable]] to true, otherwise set it to false.
// step 1.2.8. Set desc.[[Enumerable]] and desc.[[Configurable]] to true.
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/false);
desc.set_enumerable(true);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

void V8Internals::IndexedPropertyEnumeratorCallback(const v8::PropertyCallbackInfo<v8::Array>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_Internals_IndexedPropertyEnumerator");

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
Internals* blink_receiver = V8Internals::ToWrappableUnsafe(isolate, v8_receiver);
// 3.9.6. [[OwnPropertyKeys]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-ownpropertykeys
// step 2. If O supports indexed properties, then for each index of O's
//   supported property indices, in ascending numerical order, append
//   ! ToString(index) to keys.
uint32_t length = blink_receiver->length();
v8::Local<v8::Array> array =
    bindings::EnumerateIndexedProperties(isolate, length);
bindings::V8SetReturnValue(info, array);

}



}  // namespace blink
