// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_internal_enum.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Element;
class EventTarget;
class ExceptionState;
class V8TestCallback;
class V8UnionDoubleOrString;
class V8UnionInternalEnumOrInternalEnumSequence;

class  InternalDictionary : public bindings::DictionaryBase {
  
  public:
static InternalDictionary* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<InternalDictionary>(isolate);
}
static InternalDictionary* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  InternalDictionary(v8::Isolate* isolate);

bool hasAnyMember() const {
  return !member_any_member_.IsEmpty();
}
const ScriptValue& anyMember() const {
  DCHECK(hasAnyMember());
return member_any_member_;
}
ScriptValue getAnyMemberOr(const ScriptValue& fallback_value) const {
  if (!hasAnyMember()) {
  return fallback_value;
}
return member_any_member_;
}
void setAnyMember(const ScriptValue& value) {
  member_any_member_ = value;
}

bool hasBooleanMember() const {
  return has_boolean_member_;
}
bool booleanMember() const {
  DCHECK(hasBooleanMember());
return member_boolean_member_;
}
bool getBooleanMemberOr(bool fallback_value) const {
  if (!hasBooleanMember()) {
  return fallback_value;
}
return member_boolean_member_;
}
void setBooleanMember(bool value) {
  member_boolean_member_ = value;
has_boolean_member_ = true;
}

bool hasByteStringMember() const {
  return has_byte_string_member_;
}
const String& byteStringMember() const {
  DCHECK(hasByteStringMember());
return member_byte_string_member_;
}
String getByteStringMemberOr(const String& fallback_value) const;
String getByteStringMemberOr(String&& fallback_value) const;
void setByteStringMember(const String& value);
void setByteStringMember(String&& value);

bool hasCallbackFunctionMember() const {
  return has_callback_function_member_;
}
V8TestCallback* callbackFunctionMember() const {
  DCHECK(hasCallbackFunctionMember());
return member_callback_function_member_.Get();
}
V8TestCallback* getCallbackFunctionMemberOr(V8TestCallback* fallback_value) const {
  if (!hasCallbackFunctionMember()) {
  return fallback_value;
}
return member_callback_function_member_.Get();
}
void setCallbackFunctionMember(V8TestCallback* value) {
  member_callback_function_member_ = value;
has_callback_function_member_ = true;
DCHECK(member_callback_function_member_);
}

bool hasDoubleMember() const {
  return has_double_member_;
}
double doubleMember() const {
  DCHECK(hasDoubleMember());
return member_double_member_;
}
double getDoubleMemberOr(double fallback_value) const {
  if (!hasDoubleMember()) {
  return fallback_value;
}
return member_double_member_;
}
void setDoubleMember(double value) {
  member_double_member_ = value;
has_double_member_ = true;
}

bool hasDoubleOrStringMember() const {
  return has_double_or_string_member_;
}
V8UnionDoubleOrString* doubleOrStringMember() const {
  DCHECK(hasDoubleOrStringMember());
return member_double_or_string_member_.Get();
}
V8UnionDoubleOrString* getDoubleOrStringMemberOr(V8UnionDoubleOrString* fallback_value) const {
  if (!hasDoubleOrStringMember()) {
  return fallback_value;
}
return member_double_or_string_member_.Get();
}
void setDoubleOrStringMember(V8UnionDoubleOrString* value) {
  member_double_or_string_member_ = value;
has_double_or_string_member_ = true;
DCHECK(member_double_or_string_member_);
}

bool hasDoubleOrStringSequenceMember() const {
  return has_double_or_string_sequence_member_;
}
const HeapVector<Member<V8UnionDoubleOrString>>& doubleOrStringSequenceMember() const {
  DCHECK(hasDoubleOrStringSequenceMember());
return member_double_or_string_sequence_member_;
}
HeapVector<Member<V8UnionDoubleOrString>> getDoubleOrStringSequenceMemberOr(const HeapVector<Member<V8UnionDoubleOrString>>& fallback_value) const;
HeapVector<Member<V8UnionDoubleOrString>> getDoubleOrStringSequenceMemberOr(HeapVector<Member<V8UnionDoubleOrString>>&& fallback_value) const;
void setDoubleOrStringSequenceMember(const HeapVector<Member<V8UnionDoubleOrString>>& value);
void setDoubleOrStringSequenceMember(HeapVector<Member<V8UnionDoubleOrString>>&& value);

bool hasElementMember() const {
  return has_element_member_;
}
Element* elementMember() const {
  DCHECK(hasElementMember());
return member_element_member_.Get();
}
Element* getElementMemberOr(Element* fallback_value) const {
  if (!hasElementMember()) {
  return fallback_value;
}
return member_element_member_.Get();
}
void setElementMember(Element* value) {
  member_element_member_ = value;
has_element_member_ = true;
DCHECK(member_element_member_);
}

bool hasElementOrNullMember() const {
  return has_element_or_null_member_;
}
Element* elementOrNullMember() const {
  DCHECK(hasElementOrNullMember());
return member_element_or_null_member_.Get();
}
Element* getElementOrNullMemberOr(Element* fallback_value) const {
  if (!hasElementOrNullMember()) {
  return fallback_value;
}
return member_element_or_null_member_.Get();
}
void setElementOrNullMember(Element* value) {
  member_element_or_null_member_ = value;
has_element_or_null_member_ = true;
}

bool hasEnumMember() const {
  return has_enum_member_;
}
V8InternalEnum enumMember() const {
  DCHECK(hasEnumMember());
return member_enum_member_;
}
V8InternalEnum getEnumMemberOr(V8InternalEnum fallback_value) const {
  if (!hasEnumMember()) {
  return fallback_value;
}
return member_enum_member_;
}
void setEnumMember(V8InternalEnum value) {
  member_enum_member_ = value;
has_enum_member_ = true;
}
void setEnumMember(V8InternalEnum::Enum value) {
  member_enum_member_ = V8InternalEnum(value);
has_enum_member_ = true;
}

bool hasEnumMemberWithDefault() const {
  return true;
}
V8InternalEnum enumMemberWithDefault() const {
  return member_enum_member_with_default_;
}
void setEnumMemberWithDefault(V8InternalEnum value) {
  member_enum_member_with_default_ = value;
}
void setEnumMemberWithDefault(V8InternalEnum::Enum value) {
  member_enum_member_with_default_ = V8InternalEnum(value);
}

bool hasEnumOrNullMember() const {
  return has_enum_or_null_member_;
}
const std::optional<V8InternalEnum>& enumOrNullMember() const {
  DCHECK(hasEnumOrNullMember());
return member_enum_or_null_member_;
}
std::optional<V8InternalEnum> getEnumOrNullMemberOr(const std::optional<V8InternalEnum>& fallback_value) const {
  if (!hasEnumOrNullMember()) {
  return fallback_value;
}
return member_enum_or_null_member_;
}
void setEnumOrNullMember(const std::optional<V8InternalEnum>& value) {
  member_enum_or_null_member_ = value;
has_enum_or_null_member_ = true;
}
void setEnumOrNullMember(V8InternalEnum value) {
  member_enum_or_null_member_ = value;
has_enum_or_null_member_ = true;
}
void setEnumOrNullMember(V8InternalEnum::Enum value) {
  member_enum_or_null_member_ = V8InternalEnum(value);
has_enum_or_null_member_ = true;
}

bool hasEventTargetOrNullMember() const {
  return true;
}
EventTarget* eventTargetOrNullMember() const {
  return member_event_target_or_null_member_.Get();
}
void setEventTargetOrNullMember(EventTarget* value) {
  member_event_target_or_null_member_ = value;
}

bool hasInternalEnumOrInternalEnumSequenceMember() const {
  return has_internal_enum_or_internal_enum_sequence_member_;
}
V8UnionInternalEnumOrInternalEnumSequence* internalEnumOrInternalEnumSequenceMember() const {
  DCHECK(hasInternalEnumOrInternalEnumSequenceMember());
return member_internal_enum_or_internal_enum_sequence_member_.Get();
}
V8UnionInternalEnumOrInternalEnumSequence* getInternalEnumOrInternalEnumSequenceMemberOr(V8UnionInternalEnumOrInternalEnumSequence* fallback_value) const {
  if (!hasInternalEnumOrInternalEnumSequenceMember()) {
  return fallback_value;
}
return member_internal_enum_or_internal_enum_sequence_member_.Get();
}
void setInternalEnumOrInternalEnumSequenceMember(V8UnionInternalEnumOrInternalEnumSequence* value) {
  member_internal_enum_or_internal_enum_sequence_member_ = value;
has_internal_enum_or_internal_enum_sequence_member_ = true;
DCHECK(member_internal_enum_or_internal_enum_sequence_member_);
}

bool hasLongMember() const {
  return has_long_member_;
}
int32_t longMember() const {
  DCHECK(hasLongMember());
return member_long_member_;
}
int32_t getLongMemberOr(int32_t fallback_value) const {
  if (!hasLongMember()) {
  return fallback_value;
}
return member_long_member_;
}
void setLongMember(int32_t value) {
  member_long_member_ = value;
has_long_member_ = true;
}

bool hasLongMemberWithClamp() const {
  return has_long_member_with_clamp_;
}
int32_t longMemberWithClamp() const {
  DCHECK(hasLongMemberWithClamp());
return member_long_member_with_clamp_;
}
int32_t getLongMemberWithClampOr(int32_t fallback_value) const {
  if (!hasLongMemberWithClamp()) {
  return fallback_value;
}
return member_long_member_with_clamp_;
}
void setLongMemberWithClamp(int32_t value) {
  member_long_member_with_clamp_ = value;
has_long_member_with_clamp_ = true;
}

bool hasLongMemberWithDefault() const {
  return true;
}
int32_t longMemberWithDefault() const {
  return member_long_member_with_default_;
}
void setLongMemberWithDefault(int32_t value) {
  member_long_member_with_default_ = value;
}

bool hasLongMemberWithEnforceRange() const {
  return has_long_member_with_enforce_range_;
}
int32_t longMemberWithEnforceRange() const {
  DCHECK(hasLongMemberWithEnforceRange());
return member_long_member_with_enforce_range_;
}
int32_t getLongMemberWithEnforceRangeOr(int32_t fallback_value) const {
  if (!hasLongMemberWithEnforceRange()) {
  return fallback_value;
}
return member_long_member_with_enforce_range_;
}
void setLongMemberWithEnforceRange(int32_t value) {
  member_long_member_with_enforce_range_ = value;
has_long_member_with_enforce_range_ = true;
}

bool hasLongOrNullMember() const {
  return has_long_or_null_member_;
}
const std::optional<int32_t>& longOrNullMember() const {
  DCHECK(hasLongOrNullMember());
return member_long_or_null_member_;
}
std::optional<int32_t> getLongOrNullMemberOr(const std::optional<int32_t>& fallback_value) const {
  if (!hasLongOrNullMember()) {
  return fallback_value;
}
return member_long_or_null_member_;
}
void setLongOrNullMember(const std::optional<int32_t>& value) {
  member_long_or_null_member_ = value;
has_long_or_null_member_ = true;
}
void setLongOrNullMember(int32_t value) {
  member_long_or_null_member_ = value;
has_long_or_null_member_ = true;
}

bool hasLongOrNullMemberWithDefault() const {
  return true;
}
const std::optional<int32_t>& longOrNullMemberWithDefault() const {
  return member_long_or_null_member_with_default_;
}
void setLongOrNullMemberWithDefault(const std::optional<int32_t>& value) {
  member_long_or_null_member_with_default_ = value;
}
void setLongOrNullMemberWithDefault(int32_t value) {
  member_long_or_null_member_with_default_ = value;
}

bool hasObjectMember() const {
  return has_object_member_;
}
const ScriptObject& objectMember() const {
  DCHECK(hasObjectMember());
return member_object_member_;
}
ScriptObject getObjectMemberOr(const ScriptObject& fallback_value) const {
  if (!hasObjectMember()) {
  return fallback_value;
}
return member_object_member_;
}
void setObjectMember(const ScriptObject& value) {
  member_object_member_ = value;
has_object_member_ = true;
}

bool hasObjectOrNullMemberWithDefault() const {
  return true;
}
const ScriptObject& objectOrNullMemberWithDefault() const {
  return member_object_or_null_member_with_default_;
}
void setObjectOrNullMemberWithDefault(const ScriptObject& value) {
  member_object_or_null_member_with_default_ = value;
}

bool hasStringMember() const {
  return has_string_member_;
}
const String& stringMember() const {
  DCHECK(hasStringMember());
return member_string_member_;
}
String getStringMemberOr(const String& fallback_value) const;
String getStringMemberOr(String&& fallback_value) const;
void setStringMember(const String& value);
void setStringMember(String&& value);

bool hasStringMemberWithDefault() const {
  return true;
}
const String& stringMemberWithDefault() const {
  return member_string_member_with_default_;
}
void setStringMemberWithDefault(const String& value);
void setStringMemberWithDefault(String&& value);

bool hasStringSequenceMember() const {
  return has_string_sequence_member_;
}
const Vector<String>& stringSequenceMember() const {
  DCHECK(hasStringSequenceMember());
return member_string_sequence_member_;
}
Vector<String> getStringSequenceMemberOr(const Vector<String>& fallback_value) const;
Vector<String> getStringSequenceMemberOr(Vector<String>&& fallback_value) const;
void setStringSequenceMember(const Vector<String>& value);
void setStringSequenceMember(Vector<String>&& value);

bool hasStringSequenceMemberWithDefault() const {
  return true;
}
const Vector<String>& stringSequenceMemberWithDefault() const {
  return member_string_sequence_member_with_default_;
}
void setStringSequenceMemberWithDefault(const Vector<String>& value);
void setStringSequenceMemberWithDefault(Vector<String>&& value);

bool hasStringSequenceOrNullMember() const {
  return has_string_sequence_or_null_member_;
}
const std::optional<Vector<String>>& stringSequenceOrNullMember() const {
  DCHECK(hasStringSequenceOrNullMember());
return member_string_sequence_or_null_member_;
}
std::optional<Vector<String>> getStringSequenceOrNullMemberOr(const std::optional<Vector<String>>& fallback_value) const;
std::optional<Vector<String>> getStringSequenceOrNullMemberOr(std::optional<Vector<String>>&& fallback_value) const;
void setStringSequenceOrNullMember(const std::optional<Vector<String>>& value);
void setStringSequenceOrNullMember(std::optional<Vector<String>>&& value);
void setStringSequenceOrNullMember(const Vector<String>& value);
void setStringSequenceOrNullMember(Vector<String>&& value);

bool hasUnrestrictedDoubleMember() const {
  return has_unrestricted_double_member_;
}
double unrestrictedDoubleMember() const {
  DCHECK(hasUnrestrictedDoubleMember());
return member_unrestricted_double_member_;
}
double getUnrestrictedDoubleMemberOr(double fallback_value) const {
  if (!hasUnrestrictedDoubleMember()) {
  return fallback_value;
}
return member_unrestricted_double_member_;
}
void setUnrestrictedDoubleMember(double value) {
  member_unrestricted_double_member_ = value;
has_unrestricted_double_member_ = true;
}

bool hasUsvStringMember() const {
  return has_usv_string_member_;
}
const String& usvStringMember() const {
  DCHECK(hasUsvStringMember());
return member_usv_string_member_;
}
String getUsvStringMemberOr(const String& fallback_value) const;
String getUsvStringMemberOr(String&& fallback_value) const;
void setUsvStringMember(const String& value);
void setUsvStringMember(String&& value);


// Obsolete accessor functions
bool hasEnumOrNullMemberNonNull() const {
  return hasEnumOrNullMember() && enumOrNullMember().has_value();
}
V8InternalEnum enumOrNullMemberNonNull() const {
  DCHECK(hasEnumOrNullMemberNonNull());
return enumOrNullMember().value();
}
bool hasLongOrNullMemberNonNull() const {
  return hasLongOrNullMember() && longOrNullMember().has_value();
}
int32_t longOrNullMemberNonNull() const {
  DCHECK(hasLongOrNullMemberNonNull());
return longOrNullMember().value();
}
bool hasLongOrNullMemberWithDefaultNonNull() const {
  return hasLongOrNullMemberWithDefault() && longOrNullMemberWithDefault().has_value();
}
int32_t longOrNullMemberWithDefaultNonNull() const {
  DCHECK(hasLongOrNullMemberWithDefaultNonNull());
return longOrNullMemberWithDefault().value();
}
bool hasStringSequenceOrNullMemberNonNull() const {
  return hasStringSequenceOrNullMember() && stringSequenceOrNullMember().has_value();
}
const Vector<String>& stringSequenceOrNullMemberNonNull() const {
  DCHECK(hasStringSequenceOrNullMemberNonNull());
return stringSequenceOrNullMember().value();
}

void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 29;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_boolean_member_ = false;
bool has_byte_string_member_ = false;
bool has_callback_function_member_ = false;
bool has_double_member_ = false;
bool has_double_or_string_member_ = false;
bool has_double_or_string_sequence_member_ = false;
bool has_element_member_ = false;
bool has_element_or_null_member_ = false;
bool has_enum_member_ = false;
bool has_enum_or_null_member_ = false;
bool has_internal_enum_or_internal_enum_sequence_member_ = false;
bool has_long_member_ = false;
bool has_long_member_with_clamp_ = false;
bool has_long_member_with_enforce_range_ = false;
bool has_long_or_null_member_ = false;
bool has_object_member_ = false;
bool has_string_member_ = false;
bool has_string_sequence_member_ = false;
bool has_string_sequence_or_null_member_ = false;
bool has_unrestricted_double_member_ = false;
bool has_usv_string_member_ = false;

ScriptValue member_any_member_;
bool member_boolean_member_;
String member_byte_string_member_;
Member<V8TestCallback> member_callback_function_member_;
double member_double_member_;
Member<V8UnionDoubleOrString> member_double_or_string_member_;
HeapVector<Member<V8UnionDoubleOrString>> member_double_or_string_sequence_member_;
Member<Element> member_element_member_;
Member<Element> member_element_or_null_member_;
V8InternalEnum member_enum_member_{static_cast<V8InternalEnum::Enum>(0)};
V8InternalEnum member_enum_member_with_default_{V8InternalEnum::Enum::kFoo};
std::optional<V8InternalEnum> member_enum_or_null_member_;
Member<EventTarget> member_event_target_or_null_member_{nullptr};
Member<V8UnionInternalEnumOrInternalEnumSequence> member_internal_enum_or_internal_enum_sequence_member_;
int32_t member_long_member_;
int32_t member_long_member_with_clamp_;
int32_t member_long_member_with_default_{42};
int32_t member_long_member_with_enforce_range_;
std::optional<int32_t> member_long_or_null_member_;
std::optional<int32_t> member_long_or_null_member_with_default_;
ScriptObject member_object_member_;
ScriptObject member_object_or_null_member_with_default_;
String member_string_member_;
String member_string_member_with_default_{"defaultStringValue"};
Vector<String> member_string_sequence_member_;
Vector<String> member_string_sequence_member_with_default_;
std::optional<Vector<String>> member_string_sequence_or_null_member_;
double member_unrestricted_double_member_;
String member_usv_string_member_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_H_
