// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_internal_dictionary.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_test_callback.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_double_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_internalenum_internalenumsequence.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/dom/events/event_target.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"anyMember",
"booleanMember",
"byteStringMember",
"callbackFunctionMember",
"doubleMember",
"doubleOrStringMember",
"doubleOrStringSequenceMember",
"elementMember",
"elementOrNullMember",
"enumMember",
"enumMemberWithDefault",
"enumOrNullMember",
"eventTargetOrNullMember",
"internalEnumOrInternalEnumSequenceMember",
"longMember",
"longMemberWithClamp",
"longMemberWithDefault",
"longMemberWithEnforceRange",
"longOrNullMember",
"longOrNullMemberWithDefault",
"objectMember",
"objectOrNullMemberWithDefault",
"stringMember",
"stringMemberWithDefault",
"stringSequenceMember",
"stringSequenceMemberWithDefault",
"stringSequenceOrNullMember",
"unrestrictedDoubleMember",
"usvStringMember",
};


}  // namespace 

InternalDictionary* InternalDictionary::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  InternalDictionary* dictionary = MakeGarbageCollected<InternalDictionary>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "InternalDictionary";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 InternalDictionary::InternalDictionary(v8::Isolate* isolate) : member_object_or_null_member_with_default_(isolate, v8::Null(isolate)) {
  
}

















String InternalDictionary::getByteStringMemberOr(const String& fallback_value) const {
  if (!hasByteStringMember()) {
  return fallback_value;
}
return member_byte_string_member_;
}

String InternalDictionary::getByteStringMemberOr(String&& fallback_value) const {
  if (!hasByteStringMember()) {
  return std::move(fallback_value);
}
return member_byte_string_member_;
}

void InternalDictionary::setByteStringMember(const String& value) {
  member_byte_string_member_ = value;
has_byte_string_member_ = true;
}

void InternalDictionary::setByteStringMember(String&& value) {
  member_byte_string_member_ = std::move(value);
has_byte_string_member_ = true;
}

























HeapVector<Member<V8UnionDoubleOrString>> InternalDictionary::getDoubleOrStringSequenceMemberOr(const HeapVector<Member<V8UnionDoubleOrString>>& fallback_value) const {
  if (!hasDoubleOrStringSequenceMember()) {
  return fallback_value;
}
return member_double_or_string_sequence_member_;
}

HeapVector<Member<V8UnionDoubleOrString>> InternalDictionary::getDoubleOrStringSequenceMemberOr(HeapVector<Member<V8UnionDoubleOrString>>&& fallback_value) const {
  if (!hasDoubleOrStringSequenceMember()) {
  return std::move(fallback_value);
}
return member_double_or_string_sequence_member_;
}

void InternalDictionary::setDoubleOrStringSequenceMember(const HeapVector<Member<V8UnionDoubleOrString>>& value) {
  member_double_or_string_sequence_member_ = value;
has_double_or_string_sequence_member_ = true;
}

void InternalDictionary::setDoubleOrStringSequenceMember(HeapVector<Member<V8UnionDoubleOrString>>&& value) {
  member_double_or_string_sequence_member_ = std::move(value);
has_double_or_string_sequence_member_ = true;
}



































































































String InternalDictionary::getStringMemberOr(const String& fallback_value) const {
  if (!hasStringMember()) {
  return fallback_value;
}
return member_string_member_;
}

String InternalDictionary::getStringMemberOr(String&& fallback_value) const {
  if (!hasStringMember()) {
  return std::move(fallback_value);
}
return member_string_member_;
}

void InternalDictionary::setStringMember(const String& value) {
  member_string_member_ = value;
has_string_member_ = true;
}

void InternalDictionary::setStringMember(String&& value) {
  member_string_member_ = std::move(value);
has_string_member_ = true;
}




void InternalDictionary::setStringMemberWithDefault(const String& value) {
  member_string_member_with_default_ = value;
}

void InternalDictionary::setStringMemberWithDefault(String&& value) {
  member_string_member_with_default_ = std::move(value);
}




Vector<String> InternalDictionary::getStringSequenceMemberOr(const Vector<String>& fallback_value) const {
  if (!hasStringSequenceMember()) {
  return fallback_value;
}
return member_string_sequence_member_;
}

Vector<String> InternalDictionary::getStringSequenceMemberOr(Vector<String>&& fallback_value) const {
  if (!hasStringSequenceMember()) {
  return std::move(fallback_value);
}
return member_string_sequence_member_;
}

void InternalDictionary::setStringSequenceMember(const Vector<String>& value) {
  member_string_sequence_member_ = value;
has_string_sequence_member_ = true;
}

void InternalDictionary::setStringSequenceMember(Vector<String>&& value) {
  member_string_sequence_member_ = std::move(value);
has_string_sequence_member_ = true;
}




void InternalDictionary::setStringSequenceMemberWithDefault(const Vector<String>& value) {
  member_string_sequence_member_with_default_ = value;
}

void InternalDictionary::setStringSequenceMemberWithDefault(Vector<String>&& value) {
  member_string_sequence_member_with_default_ = std::move(value);
}




std::optional<Vector<String>> InternalDictionary::getStringSequenceOrNullMemberOr(const std::optional<Vector<String>>& fallback_value) const {
  if (!hasStringSequenceOrNullMember()) {
  return fallback_value;
}
return member_string_sequence_or_null_member_;
}

std::optional<Vector<String>> InternalDictionary::getStringSequenceOrNullMemberOr(std::optional<Vector<String>>&& fallback_value) const {
  if (!hasStringSequenceOrNullMember()) {
  return std::move(fallback_value);
}
return member_string_sequence_or_null_member_;
}

void InternalDictionary::setStringSequenceOrNullMember(const std::optional<Vector<String>>& value) {
  member_string_sequence_or_null_member_ = value;
has_string_sequence_or_null_member_ = true;
}

void InternalDictionary::setStringSequenceOrNullMember(std::optional<Vector<String>>&& value) {
  member_string_sequence_or_null_member_ = std::move(value);
has_string_sequence_or_null_member_ = true;
}

void InternalDictionary::setStringSequenceOrNullMember(const Vector<String>& value) {
  member_string_sequence_or_null_member_ = value;
has_string_sequence_or_null_member_ = true;
}

void InternalDictionary::setStringSequenceOrNullMember(Vector<String>&& value) {
  member_string_sequence_or_null_member_ = std::move(value);
has_string_sequence_or_null_member_ = true;
}










String InternalDictionary::getUsvStringMemberOr(const String& fallback_value) const {
  if (!hasUsvStringMember()) {
  return fallback_value;
}
return member_usv_string_member_;
}

String InternalDictionary::getUsvStringMemberOr(String&& fallback_value) const {
  if (!hasUsvStringMember()) {
  return std::move(fallback_value);
}
return member_usv_string_member_;
}

void InternalDictionary::setUsvStringMember(const String& value) {
  member_usv_string_member_ = value;
has_usv_string_member_ = true;
}

void InternalDictionary::setUsvStringMember(String&& value) {
  member_usv_string_member_ = std::move(value);
has_usv_string_member_ = true;
}




void InternalDictionary::Trace(Visitor* visitor) const {
  visitor->Trace(member_any_member_);
visitor->Trace(member_callback_function_member_);
visitor->Trace(member_double_or_string_member_);
visitor->Trace(member_double_or_string_sequence_member_);
visitor->Trace(member_element_member_);
visitor->Trace(member_element_or_null_member_);
visitor->Trace(member_event_target_or_null_member_);
visitor->Trace(member_internal_enum_or_internal_enum_sequence_member_);
visitor->Trace(member_object_member_);
visitor->Trace(member_object_or_null_member_with_default_);
bindings::DictionaryBase::Trace(visitor);
}

void InternalDictionary::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void InternalDictionary::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAnyMember()) {
  values[0] = ToV8Traits<IDLAny>::ToV8(script_state, member_any_member_);
DCHECK(!values[0].IsEmpty());
}
if (hasBooleanMember()) {
  values[1] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_boolean_member_);
DCHECK(!values[1].IsEmpty());
}
if (hasByteStringMember()) {
  values[2] = ToV8Traits<IDLByteString>::ToV8(script_state, member_byte_string_member_);
DCHECK(!values[2].IsEmpty());
}
if (hasCallbackFunctionMember()) {
  values[3] = ToV8Traits<V8TestCallback>::ToV8(script_state, member_callback_function_member_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasDoubleMember()) {
  values[4] = ToV8Traits<IDLDouble>::ToV8(script_state, member_double_member_);
DCHECK(!values[4].IsEmpty());
}
if (hasDoubleOrStringMember()) {
  values[5] = ToV8Traits<V8UnionDoubleOrString>::ToV8(script_state, member_double_or_string_member_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasDoubleOrStringSequenceMember()) {
  values[6] = ToV8Traits<IDLSequence<V8UnionDoubleOrString>>::ToV8(script_state, member_double_or_string_sequence_member_);
DCHECK(!values[6].IsEmpty());
}
if (hasElementMember()) {
  values[7] = ToV8Traits<Element>::ToV8(script_state, member_element_member_.Get());
DCHECK(!values[7].IsEmpty());
}
if (hasElementOrNullMember()) {
  values[8] = ToV8Traits<IDLNullable<Element>>::ToV8(script_state, member_element_or_null_member_.Get());
DCHECK(!values[8].IsEmpty());
}
if (hasEnumMember()) {
  values[9] = ToV8Traits<V8InternalEnum>::ToV8(script_state, member_enum_member_);
DCHECK(!values[9].IsEmpty());
}
if (hasEnumMemberWithDefault()) {
  values[10] = ToV8Traits<V8InternalEnum>::ToV8(script_state, member_enum_member_with_default_);
DCHECK(!values[10].IsEmpty());
}
if (hasEnumOrNullMember()) {
  values[11] = ToV8Traits<IDLNullable<V8InternalEnum>>::ToV8(script_state, member_enum_or_null_member_);
DCHECK(!values[11].IsEmpty());
}
if (hasEventTargetOrNullMember()) {
  values[12] = ToV8Traits<IDLNullable<EventTarget>>::ToV8(script_state, member_event_target_or_null_member_.Get());
DCHECK(!values[12].IsEmpty());
}
if (hasInternalEnumOrInternalEnumSequenceMember()) {
  values[13] = ToV8Traits<V8UnionInternalEnumOrInternalEnumSequence>::ToV8(script_state, member_internal_enum_or_internal_enum_sequence_member_.Get());
DCHECK(!values[13].IsEmpty());
}
if (hasLongMember()) {
  values[14] = ToV8Traits<IDLLong>::ToV8(script_state, member_long_member_);
DCHECK(!values[14].IsEmpty());
}
if (hasLongMemberWithClamp()) {
  values[15] = ToV8Traits<IDLLongClamp>::ToV8(script_state, member_long_member_with_clamp_);
DCHECK(!values[15].IsEmpty());
}
if (hasLongMemberWithDefault()) {
  values[16] = ToV8Traits<IDLLong>::ToV8(script_state, member_long_member_with_default_);
DCHECK(!values[16].IsEmpty());
}
if (hasLongMemberWithEnforceRange()) {
  values[17] = ToV8Traits<IDLLongEnforceRange>::ToV8(script_state, member_long_member_with_enforce_range_);
DCHECK(!values[17].IsEmpty());
}
if (hasLongOrNullMember()) {
  values[18] = ToV8Traits<IDLNullable<IDLLong>>::ToV8(script_state, member_long_or_null_member_);
DCHECK(!values[18].IsEmpty());
}
if (hasLongOrNullMemberWithDefault()) {
  values[19] = ToV8Traits<IDLNullable<IDLLong>>::ToV8(script_state, member_long_or_null_member_with_default_);
DCHECK(!values[19].IsEmpty());
}
if (hasObjectMember()) {
  values[20] = ToV8Traits<IDLObject>::ToV8(script_state, member_object_member_);
DCHECK(!values[20].IsEmpty());
}
if (hasObjectOrNullMemberWithDefault()) {
  values[21] = ToV8Traits<IDLNullable<IDLObject>>::ToV8(script_state, member_object_or_null_member_with_default_);
DCHECK(!values[21].IsEmpty());
}
if (hasStringMember()) {
  values[22] = ToV8Traits<IDLString>::ToV8(script_state, member_string_member_);
DCHECK(!values[22].IsEmpty());
}
if (hasStringMemberWithDefault()) {
  values[23] = ToV8Traits<IDLString>::ToV8(script_state, member_string_member_with_default_);
DCHECK(!values[23].IsEmpty());
}
if (hasStringSequenceMember()) {
  values[24] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_string_sequence_member_);
DCHECK(!values[24].IsEmpty());
}
if (hasStringSequenceMemberWithDefault()) {
  values[25] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_string_sequence_member_with_default_);
DCHECK(!values[25].IsEmpty());
}
if (hasStringSequenceOrNullMember()) {
  values[26] = ToV8Traits<IDLNullable<IDLSequence<IDLString>>>::ToV8(script_state, member_string_sequence_or_null_member_);
DCHECK(!values[26].IsEmpty());
}
if (hasUnrestrictedDoubleMember()) {
  values[27] = ToV8Traits<IDLUnrestrictedDouble>::ToV8(script_state, member_unrestricted_double_member_);
DCHECK(!values[27].IsEmpty());
}
if (hasUsvStringMember()) {
  values[28] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_usv_string_member_);
DCHECK(!values[28].IsEmpty());
}
}

const void* InternalDictionary::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> InternalDictionary::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void InternalDictionary::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "InternalDictionary";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("anyMember");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLAny, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_any_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("booleanMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_boolean_member_, member_boolean_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("byteStringMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLByteString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_byte_string_member_, member_byte_string_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("callbackFunctionMember");
if (!bindings::GetDictionaryMemberFromV8Object<V8TestCallback, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_callback_function_member_, member_callback_function_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("doubleMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_double_member_, member_double_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("doubleOrStringMember");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionDoubleOrString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_double_or_string_member_, member_double_or_string_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("doubleOrStringSequenceMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8UnionDoubleOrString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_double_or_string_sequence_member_, member_double_or_string_sequence_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("elementMember");
if (!bindings::GetDictionaryMemberFromV8Object<Element, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_element_member_, member_element_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("elementOrNullMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<Element>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_element_or_null_member_, member_element_or_null_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enumMember");
if (!bindings::GetDictionaryMemberFromV8Object<V8InternalEnum, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_enum_member_, member_enum_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enumMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8InternalEnum, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_enum_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("enumOrNullMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<V8InternalEnum>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_enum_or_null_member_, member_enum_or_null_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventTargetOrNullMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<EventTarget>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), fallback_presence_var, member_event_target_or_null_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("internalEnumOrInternalEnumSequenceMember");
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionInternalEnumOrInternalEnumSequence, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_internal_enum_or_internal_enum_sequence_member_, member_internal_enum_or_internal_enum_sequence_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_long_member_, member_long_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longMemberWithClamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongClamp, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_long_member_with_clamp_, member_long_member_with_clamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), fallback_presence_var, member_long_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longMemberWithEnforceRange");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_long_member_with_enforce_range_, member_long_member_with_enforce_range_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longOrNullMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_long_or_null_member_, member_long_or_null_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("longOrNullMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLLong>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), fallback_presence_var, member_long_or_null_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("objectMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLObject, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_object_member_, member_object_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("objectOrNullMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLObject>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), fallback_presence_var, member_object_or_null_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stringMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_string_member_, member_string_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stringMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), fallback_presence_var, member_string_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stringSequenceMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_string_sequence_member_, member_string_sequence_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stringSequenceMemberWithDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[25].Get(isolate), fallback_presence_var, member_string_sequence_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("stringSequenceOrNullMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLNullable<IDLSequence<IDLString>>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[26].Get(isolate), has_string_sequence_or_null_member_, member_string_sequence_or_null_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("unrestrictedDoubleMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnrestrictedDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[27].Get(isolate), has_unrestricted_double_member_, member_unrestricted_double_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("usvStringMember");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[28].Get(isolate), has_usv_string_member_, member_usv_string_member_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> InternalDictionary::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
