// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_DATA_SETTINGS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_DATA_SETTINGS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data_pixel_format.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ImageDataSettings : public bindings::InputDictionaryBase {
  
  public:
static ImageDataSettings* Create() {
  return MakeGarbageCollected<ImageDataSettings>();
}
static ImageDataSettings* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ImageDataSettings>(isolate);
}
static ImageDataSettings* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ImageDataSettings();
explicit  ImageDataSettings(v8::Isolate* isolate);

bool hasColorSpace() const {
  return has_color_space_;
}
V8PredefinedColorSpace colorSpace() const {
  DCHECK(hasColorSpace());
return member_color_space_;
}
V8PredefinedColorSpace getColorSpaceOr(V8PredefinedColorSpace fallback_value) const {
  if (!hasColorSpace()) {
  return fallback_value;
}
return member_color_space_;
}
void setColorSpace(V8PredefinedColorSpace value) {
  member_color_space_ = value;
has_color_space_ = true;
}
void setColorSpace(V8PredefinedColorSpace::Enum value) {
  member_color_space_ = V8PredefinedColorSpace(value);
has_color_space_ = true;
}

bool hasPixelFormat() const {
  return true;
}
V8ImageDataPixelFormat pixelFormat() const {
  return member_pixel_format_;
}
void setPixelFormat(V8ImageDataPixelFormat value) {
  member_pixel_format_ = value;
}
void setPixelFormat(V8ImageDataPixelFormat::Enum value) {
  member_pixel_format_ = V8ImageDataPixelFormat(value);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_color_space_ = false;

V8PredefinedColorSpace member_color_space_{static_cast<V8PredefinedColorSpace::Enum>(0)};
V8ImageDataPixelFormat member_pixel_format_{V8ImageDataPixelFormat::Enum::kRgbaUnorm8};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_DATA_SETTINGS_H_
