// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_BITMAP_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_BITMAP_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_color_space_conversion.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_orientation.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_premultiply_alpha.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_resize_quality.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ImageBitmapOptions : public bindings::InputDictionaryBase {
  
  public:
static ImageBitmapOptions* Create() {
  return MakeGarbageCollected<ImageBitmapOptions>();
}
static ImageBitmapOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ImageBitmapOptions>(isolate);
}
static ImageBitmapOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ImageBitmapOptions();
explicit  ImageBitmapOptions(v8::Isolate* isolate);

bool hasColorSpaceConversion() const {
  return true;
}
V8ColorSpaceConversion colorSpaceConversion() const {
  return member_color_space_conversion_;
}
void setColorSpaceConversion(V8ColorSpaceConversion value) {
  member_color_space_conversion_ = value;
}
void setColorSpaceConversion(V8ColorSpaceConversion::Enum value) {
  member_color_space_conversion_ = V8ColorSpaceConversion(value);
}

bool hasImageOrientation() const {
  return true;
}
V8ImageOrientation imageOrientation() const {
  return member_image_orientation_;
}
void setImageOrientation(V8ImageOrientation value) {
  member_image_orientation_ = value;
}
void setImageOrientation(V8ImageOrientation::Enum value) {
  member_image_orientation_ = V8ImageOrientation(value);
}

bool hasPremultiplyAlpha() const {
  return true;
}
V8PremultiplyAlpha premultiplyAlpha() const {
  return member_premultiply_alpha_;
}
void setPremultiplyAlpha(V8PremultiplyAlpha value) {
  member_premultiply_alpha_ = value;
}
void setPremultiplyAlpha(V8PremultiplyAlpha::Enum value) {
  member_premultiply_alpha_ = V8PremultiplyAlpha(value);
}

bool hasResizeHeight() const {
  return has_resize_height_;
}
uint32_t resizeHeight() const {
  DCHECK(hasResizeHeight());
return member_resize_height_;
}
uint32_t getResizeHeightOr(uint32_t fallback_value) const {
  if (!hasResizeHeight()) {
  return fallback_value;
}
return member_resize_height_;
}
void setResizeHeight(uint32_t value) {
  member_resize_height_ = value;
has_resize_height_ = true;
}

bool hasResizeQuality() const {
  return true;
}
V8ResizeQuality resizeQuality() const {
  return member_resize_quality_;
}
void setResizeQuality(V8ResizeQuality value) {
  member_resize_quality_ = value;
}
void setResizeQuality(V8ResizeQuality::Enum value) {
  member_resize_quality_ = V8ResizeQuality(value);
}

bool hasResizeWidth() const {
  return has_resize_width_;
}
uint32_t resizeWidth() const {
  DCHECK(hasResizeWidth());
return member_resize_width_;
}
uint32_t getResizeWidthOr(uint32_t fallback_value) const {
  if (!hasResizeWidth()) {
  return fallback_value;
}
return member_resize_width_;
}
void setResizeWidth(uint32_t value) {
  member_resize_width_ = value;
has_resize_width_ = true;
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_resize_height_ = false;
bool has_resize_width_ = false;

V8ColorSpaceConversion member_color_space_conversion_{V8ColorSpaceConversion::Enum::kDefault};
V8ImageOrientation member_image_orientation_{V8ImageOrientation::Enum::kFromImage};
V8PremultiplyAlpha member_premultiply_alpha_{V8PremultiplyAlpha::Enum::kDefault};
uint32_t member_resize_height_;
V8ResizeQuality member_resize_quality_{V8ResizeQuality::Enum::kLow};
uint32_t member_resize_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_IMAGE_BITMAP_OPTIONS_H_
