// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"colorSpaceConversion",
"imageOrientation",
"premultiplyAlpha",
"resizeHeight",
"resizeQuality",
"resizeWidth",
};


}  // namespace 

ImageBitmapOptions* ImageBitmapOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  ImageBitmapOptions* dictionary = MakeGarbageCollected<ImageBitmapOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "ImageBitmapOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 ImageBitmapOptions::ImageBitmapOptions() {
  
}

 ImageBitmapOptions::ImageBitmapOptions(v8::Isolate* isolate) {
  
}





































void ImageBitmapOptions::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void ImageBitmapOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "ImageBitmapOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("colorSpaceConversion");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8ColorSpaceConversion, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_color_space_conversion_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("imageOrientation");
if (!bindings::GetDictionaryMemberFromV8Object<V8ImageOrientation, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_image_orientation_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("premultiplyAlpha");
if (!bindings::GetDictionaryMemberFromV8Object<V8PremultiplyAlpha, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_premultiply_alpha_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeHeight");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_resize_height_, member_resize_height_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeQuality");
if (!bindings::GetDictionaryMemberFromV8Object<V8ResizeQuality, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_resize_quality_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resizeWidth");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_resize_width_, member_resize_width_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> ImageBitmapOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
