// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HASH_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HASH_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT HashChangeEventInit : public EventInit {
  
  public:
static HashChangeEventInit* Create() {
  return MakeGarbageCollected<HashChangeEventInit>();
}
static HashChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HashChangeEventInit>(isolate);
}
static HashChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HashChangeEventInit();
explicit  HashChangeEventInit(v8::Isolate* isolate);

bool hasNewURL() const {
  return has_new_url_;
}
const String& newURL() const {
  DCHECK(hasNewURL());
return member_new_url_;
}
String getNewURLOr(const String& fallback_value) const;
String getNewURLOr(String&& fallback_value) const;
void setNewURL(const String& value);
void setNewURL(String&& value);

bool hasOldURL() const {
  return has_old_url_;
}
const String& oldURL() const {
  DCHECK(hasOldURL());
return member_old_url_;
}
String getOldURLOr(const String& fallback_value) const;
String getOldURLOr(String&& fallback_value) const;
void setOldURL(const String& value);
void setOldURL(String&& value);




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_new_url_ = false;
bool has_old_url_ = false;

String member_new_url_;
String member_old_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HASH_CHANGE_EVENT_INIT_H_
