// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FULLSCREEN_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FULLSCREEN_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_fullscreen_navigation_ui.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class Screen;

class CORE_EXPORT FullscreenOptions : public bindings::InputDictionaryBase {
  
  public:
static FullscreenOptions* Create() {
  return MakeGarbageCollected<FullscreenOptions>();
}
static FullscreenOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FullscreenOptions>(isolate);
}
static FullscreenOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FullscreenOptions();
explicit  FullscreenOptions(v8::Isolate* isolate);

bool hasNavigationUI() const {
  return true;
}
V8FullscreenNavigationUI navigationUI() const {
  return member_navigation_ui_;
}
void setNavigationUI(V8FullscreenNavigationUI value) {
  member_navigation_ui_ = value;
}
void setNavigationUI(V8FullscreenNavigationUI::Enum value) {
  member_navigation_ui_ = V8FullscreenNavigationUI(value);
}

bool hasScreen() const {
  return has_screen_;
}
Screen* screen() const {
  DCHECK(hasScreen());
return member_screen_.Get();
}
Screen* getScreenOr(Screen* fallback_value) const {
  if (!hasScreen()) {
  return fallback_value;
}
return member_screen_.Get();
}
void setScreen(Screen* value) {
  member_screen_ = value;
has_screen_ = true;
DCHECK(member_screen_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_screen_ = false;

V8FullscreenNavigationUI member_navigation_ui_{V8FullscreenNavigationUI::Enum::kAuto};
Member<Screen> member_screen_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FULLSCREEN_OPTIONS_H_
