// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FORM_DATA_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FORM_DATA_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class FormData;

class CORE_EXPORT FormDataEventInit : public EventInit {
  
  public:
static FormDataEventInit* Create() {
  return MakeGarbageCollected<FormDataEventInit>();
}
static FormDataEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FormDataEventInit>(isolate);
}
static FormDataEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FormDataEventInit();
explicit  FormDataEventInit(v8::Isolate* isolate);

bool hasFormData() const {
  return true;
}
FormData* formData() const {
  return member_form_data_.Get();
}
void setFormData(FormData* value) {
  member_form_data_ = value;
DCHECK(member_form_data_);
}




void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<FormData> member_form_data_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FORM_DATA_EVENT_INIT_H_
